block('b-wallet-link')(

    def()(function() {
        var ctx = this.ctx,
            campaigns = ctx.campaigns,
            //в agencyID может приходить строка ‘0’
            agencyId = campaigns.length && +campaigns[0].AgencyID,
            wallet = (agencyId ?
                u._.extend({}, ctx.wallet.agencies[agencyId], { agencyID: agencyId }) :
                ctx.wallet.self) || {},
            walletRestrictions = u.getWalletRestrictions(wallet),
            autoPaySettings = u._.get(wallet, 'self.autopay_settings') || u._.get(wallet, 'autopay_settings') || {},
            isClient = this.data.login_rights.role === 'client',
            isWalletEnabled = wallet.enabled = !!wallet.enabled;

        return applyNext({
            campaigns: campaigns,
            ulogin: ctx.ulogin,
            linkToClientWallet: u.getWalletLink(agencyId),
            currency: ctx.currency,
            isWalletEnabled: isWalletEnabled,
            isAllowToChangeEnableWallet: walletRestrictions.isAllowToChangeEnableWallet,
            isAllowTransferMoney: walletRestrictions.isAllowTransferMoney,
            isAllowedEditCamps: walletRestrictions.isAllowedEditCamps,
            isReadOnlyWallet: walletRestrictions.isReadOnlyWallet,
            dontShowWalletLink: walletRestrictions.dontShowWalletLink,
            isAllowedPay: walletRestrictions.isAllowedPay,
            needOnlyCampModerationToPay: walletRestrictions.needOnlyCampModerationToPay,
            wallet: wallet,
            showCidAndOrderId: wallet.enabled && hasLoginRights('super_control', 'superreader_control', 'support_control', 'limited_support_control'),
            isWalletIdLinkDisabled: hasLoginRights('manager_control') ||
                isClient && ctx.wallet.agencies,
            autoPaySettings: autoPaySettings,
            isAutopaymentEnabled: !u.autopayment.params.disabled && autoPaySettings.autopay_mode,
            agencyId: agencyId
        });
    }),

    def().match(function() {
        return !this.isWalletEnabled && !this.isAllowToChangeEnableWallet;
    }).def()(function() {
        return '';
    }),

    elem('wallet-info')(
        content()(function() {
            var data = this.data,
                wallet = this.wallet,
                dailyBudget = +u._.get(wallet, 'day_budget.sum', 0),
                campaignsRests = this.campaigns.filter(function(campaign) {
                    return +campaign.total > 0;
                }),
                hint = applyCtx({
                    block: 'b-wallet-link',
                    elem: 'hint',
                    wallet: wallet,
                    currency: this.currency,
                    isWalletIdLinkDisabled: this.isWalletIdLinkDisabled,
                    linkToClientWallet: this.linkToClientWallet,
                    agencyContacts: data.campaign_agency_contacts,
                    isAllowTransferMoney: this.isAllowTransferMoney
                }),
                disabledPayButton = !this.isAllowedPay && this.needOnlyCampModerationToPay;

            return {
                elem: 'info-grid',
                content: [
                    {
                        elem: 'info-grid-row',
                        content: [
                            {
                                elem: 'info-grid-cell',
                                elemMods: { label: 'yes' },
                                content: [
                                    {
                                        elem: 'title',
                                        mix: { elem: 'valign-middle' },
                                        content: wallet.enabled ? iget2('b-wallet-link', 'obshchiy-schyot', 'Общий счёт') : iget2('b-wallet-link', 'obshchiy-schyot-otklyuchen', 'Общий счёт отключён')
                                    },
                                    !this.dontShowWalletLink &&
                                        (wallet.enabled ? true : !!wallet.total) && {
                                            block: 'link',
                                            mods: { theme: 'normal' },
                                            mix: [
                                                { block: 'b-wallet-link', elem: 'settings' },
                                                { block: 'b-wallet-link', elem: 'valign-middle' },
                                                {
                                                    block: 'b-metrika2',
                                                    js: {
                                                        nativeEvent: 'click',
                                                        params: {
                                                            showCamps: 'walletLinkClicked'
                                                        }
                                                    }
                                                }
                                            ],
                                            url: this.linkToClientWallet,
                                            icon: {
                                                block: 'icon',
                                                mods: { 'size-16': 'settings' }
                                            }
                                        }
                                ]
                            },
                            {
                                elem: 'info-grid-cell',
                                mix: { elem: 'wallet-value' },
                                content: [
                                    (wallet.enabled ? true : !!wallet.total) && {
                                        elem: 'title-sum',
                                        elemMods: { 'has-debt': wallet.total < 0 ? 'yes' : '' },
                                        mix: { elem: 'valign-middle' },
                                        content: u.currencies.formatSum(this.currency, wallet.total)
                                    },
                                    ((this.isAllowedPay && !this.isReadOnlyWallet && wallet.enabled) ||
                                        disabledPayButton) && {
                                            block: 'b-pay',
                                            mix: [
                                                { block: 'b-wallet-link', elem: 'button' },
                                                {
                                                    block: 'b-metrika2',
                                                    js: {
                                                        blockName: 'b-pay',
                                                        event: 'popup-show',
                                                        params: {
                                                            showCamps: 'walletAddMoneyClicked'
                                                        }
                                                    }
                                                }
                                            ],
                                            mods: {
                                                nds: +data.client_nds &&
                                                    !u._.contains(['YND_FIXED', 'BYN', 'KZT'], this.currency) ? 'yes' : 'no',
                                                disabled: disabledPayButton ? 'yes' : ''
                                            },
                                            wallet: wallet,
                                            clientNDS: data.client_nds,
                                            userLogin: data.FORM.ulogin,
                                            cid: wallet.wallet_cid,
                                            offerSumToPay: wallet.offer_sum_to_pay,
                                            isOfferAccepted: data.is_offer_accepted,
                                            btnText: iget2('b-wallet-link', 'popolnit', 'Пополнить'),
                                            btnSize: 'xs'
                                        },
                                    this.isAllowToChangeEnableWallet && !this.isReadOnlyWallet && !wallet.enabled && {
                                        block: 'button',
                                        mods: { theme: 'normal', size: 'xs' },
                                        mix: [
                                            { block: 'b-wallet-link', elem: 'button' },
                                            {
                                                block: 'b-metrika2',
                                                js: {
                                                    blockName: 'button',
                                                    event: 'click',
                                                    params: {
                                                        showCamps: 'enableWalletButtonClicked'
                                                    }
                                                }
                                            }
                                        ],
                                        url: this.linkToClientWallet,
                                        content: iget2('b-wallet-link', 'podklyuchit', 'Подключить')
                                    },
                                    !wallet.total && !wallet.enabled && !hint && {
                                        block: 'b-help-link',
                                        mods: {
                                            type: 'modal',
                                            decoration: 'no',
                                            margin: 'no'
                                        },
                                        mix: { block: 'b-wallet-link', elem: 'valign-middle' },
                                        stretched: true,
                                        url: u.getHelpUrl('shared-account')
                                    },
                                    hint,
                                    disabledPayButton ?
                                        {
                                            elem: 'subscription',
                                            mix: { block: 'b-wallet-link', elem: 'subscription' },
                                            content: iget2(
                                                'b-wallet-link',
                                                'popolnit-os-mozhno-tolko-posle',
                                                'Пополнить общий счёт можно только после того, как хотя бы одна кампания пройдёт модерацию')
                                        } :
                                        ''
                                ]
                            }
                        ]
                    },
                    wallet.enabled && this.isAutopaymentEnabled && {
                        elem: 'info-grid-row',
                        content: [
                            {
                                elem: 'info-grid-cell',
                                elemMods: { label: 'yes' },
                                content: [
                                    iget2('b-wallet-link', 'autopayment', 'Автоплатёж'),
                                    {
                                        block: 'b-help-link',
                                        mods: { type: 'modal', decoration: 'no' },
                                        url: u.getHelpUrl('shared-account')
                                    }
                                ]
                            },
                            {
                                block: 'b-autopayment-info',
                                mods: { 'wallet-cid': this.wallet.wallet_cid },
                                mix: { block: 'b-wallet-link', elem: 'info-grid-cell' },
                                autoPaySettings: this.autoPaySettings,
                                canResumeAutopay: u.autopayment.params.canResumeAutopay,
                                disableEditAutopay: u.autopayment.params.disableEditAutopay,
                                currency: this.currency,
                                readOnly: this.isReadOnlyWallet
                            }
                        ]
                    },
                    wallet.enabled && !!dailyBudget && {
                        elem: 'info-grid-row',
                        content: [
                            {
                                elem: 'info-grid-cell',
                                elemMods: { label: 'yes' },
                                content: iget2('b-wallet-link', 'dnevnoy-byudzhet-105', 'Дневной бюджет')
                            },
                            {
                                elem: 'info-grid-cell',
                                content: !this.isReadOnlyWallet &&
                                    (this.isAllowTransferMoney || this.isAllowedEditCamps) ?
                                        ({
                                            block: 'link',
                                            mods: { theme: 'normal' },
                                            url: u.getWalletLink(this.agencyId, { showEditTools: 'day-budget' }),
                                            content: u.currencies.formatSum(this.currency, dailyBudget),
                                            mix: [
                                                {
                                                    block: 'b-metrika2',
                                                    js: {
                                                        nativeEvent: 'click',
                                                        params: {
                                                            showCamps: 'walletDayBudgetLinkClicked'
                                                        }
                                                    }
                                                }
                                            ]
                                        }) :
                                        u.currencies.formatSum(this.currency, dailyBudget)
                            }
                        ]
                    },
                    wallet.enabled && !!campaignsRests.length && {
                        elem: 'info-grid-row',
                        content: [
                            {
                                elem: 'info-grid-cell',
                                elemMods: { label: 'yes' },
                                content: iget2('b-wallet-link', 'ostatki-na-kampaniyah', 'Остатки на кампаниях')
                            },
                            {
                                block: 'b-wallet-campaigns-rests',
                                mix: { block: 'b-wallet-link', elem: 'info-grid-cell' },
                                campaigns: campaignsRests,
                                ulogin: this.ulogin,
                                currency: this.currency
                            }
                        ]
                    }
                ]
            };
        })
    ),

    elem('account-info')(
        content()(function() {
            return [
                this.wallet.enabled && hasLoginRights('super_control', 'manager_control',
                'support_control', 'superreader_control', 'limited_support_control') && {
                    elem: 'balance',
                    mix: { elem: 'account-info-item' },
                    wallet: this.wallet
                },
                // информация о РК и БК
                this.showCidAndOrderId && {
                    elem: 'identifiers',
                    mix: { elem: 'account-info-item' },
                    wallet: this.wallet
                }
            ];
        })
    ),

    js()(true)
);
