block('b-wallet-rest')(
    addMix()([
        {
            block: 'b-metrika2',
            js: {
                items: [
                    {
                        event: 'popup-show',
                        params: {
                            ShowCamps: {
                                Pay: 'Popup'
                            }
                        }
                    },
                    {
                        event: 'bill-click',
                        params: {
                            ShowCamps: {
                                Pay: {
                                    Popup: 'Issue_an_invoice'
                                }
                            }
                        }
                    },
                    {
                        event: 'cash-click',
                        params: {
                            ShowCamps: {
                                Pay: {
                                    Popup: 'Cash_payment'
                                }
                            }
                        }
                    }
                ],
                blockName: 'b-wallet-rest'
            }
        }
    ]),
    addJs()(true),
    content()(function() {
        return [
            this.data.cmd == 'clientWallet' && iget2('b-wallet-rest', 'ostalos', 'Осталось') + ':',
            {
                elem: 'total',
                content: [
                    (this.data.login_rights.super_control || this.data.login_rights.manager_control ||
                        this.data.login_rights.support_control) ?
                            u.spacer([
                                {
                                    block: 'link',
                                    target: '_blank',
                                    url: u.formatUrl({
                                        host: u.consts('balance_admin'),
                                        path: 'order.xml',
                                        query: {
                                            service_cc: 'PPC',
                                            service_order_id: this.ctx.wallet.wallet_cid
                                        }
                                    }),
                                    content: u.numberFormatter.format(this.ctx.wallet.total, {
                                        precision: 2
                                    })
                                },
                                u.currencies.getName(this.data.work_currency),
                                this.data.work_currency === 'YND_FIXED' ? '' : iget2('b-wallet-rest', 'bez-nds', 'без НДС.')
                            ]) :
                            u.spacer([
                                u.currencies.formatSum(this.data.work_currency, this.ctx.wallet.total),
                                this.data.work_currency === 'YND_FIXED' ? '' : iget2('b-wallet-rest', 'bez-nds', 'без НДС.')
                            ]),
                    this.ctx.wallet.money_type != 'real' && this.ctx.wallet.total > 0 && {
                        block: 'b-help-link',
                        mods: {
                            align: 'top'
                        },
                        url: u.getHelpUrl('shared-account-not-spent')
                    }
                ]
            },
            !!+this.ctx.wallet.bonus && this.data.cmd != 'clientWallet' && {
                elem: 'bonus',
                wallet: this.ctx.wallet
            },
        //не показываем вешальщикам
            !this.data.login_rights.placer_control &&
            //суперридерам
            !this.data.login_rights.superreader_control &&
                //медиапланерам
                !(this.data.login_rights.role == 'media') &&
                //ограниченным представителям у которых нет возможности выставления счёта
                !(this.data.login_rights.is_agency_limited && +this.data.login_rights.agency_limited_no_pay) &&
                //если у данного клиента не стоит галка allow_pay
                !!this.ctx.wallet.allow_pay && {
                    block: 'b-pay',
                    mix: { block: 'b-wallet-rest', elem: 'pay' },
                    mods: {
                        nds: +this.data.client_nds &&
                            !u._.contains(['YND_FIXED', 'BYN', 'KZT'], this.data.work_currency) ? 'yes' : 'no'
                    },
                    wallet: this.ctx.wallet,
                    clientNDS: this.data.client_nds,
                    userLogin: this.data.FORM.ulogin,
                    cid: this.ctx.wallet.wallet_cid,
                    offerSumToPay: this.ctx.wallet.offer_sum_to_pay
                },
            !!+this.ctx.wallet.bonus && this.data.cmd == 'clientWallet' && {
                elem: 'bonus',
                wallet: this.ctx.wallet
            }
        ];
    }),

    elem('bonus').content()(function() {
        return [
            '(' + iget2('b-wallet-rest', 'iz-nih-s-skidochnyy', 'из них {foo} скидочный бонус', {
                foo: '<strong>' +
                    u.currencies.formatSum(this.data.work_currency, this.ctx.wallet.bonus) + '</strong>'
            }),
            {
                block: 'b-help-link',
                mix: [{
                    block: 'b-wallet-link',
                    elem: 'help'
                }],
                url: u.getHelpUrl('bonus'),
                windowParams: {
                    height: 800
                }
            },
            ')'
        ];
    })
);
