/**
 *
 * @event b-wallet-rest#popup-show popup стал виден
 * @event b-wallet-rest#bill-click Клик на кнопке "Выставить счет" дочернего блока b-pay
 * @event b-wallet-rest#cash-click Клик на кнопке "Оплатить наличными" дочернего блока b-pay
 *
 * @fires b-wallet-rest#popup-show
 * @fires b-wallet-rest#bill-click
 * @fires b-wallet-rest#cash-click
 */
BEM.DOM.decl('b-wallet-rest', {
    onSetMod: {
        js: function() {
            this._initEvents();
        }
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscriptionManager && this._subscriptionManager.dispose();
        this.__base();
    },

    /**
     * Подписка на события дочерних блоков,
     * Проксирование событий вверх
     * @private
     */
    _initEvents: function() {
        var bPay = this.findBlockInside('b-pay');

        if (bPay) {
            this._subscriptionManager = BEM.create('i-subscription-manager');
            this._subscriptionManager
                .wrap(bPay)
                .on('popup-show', function() {
                    this.trigger('popup-show');
                }, this)
                .on('bill-click', function() {
                    this.trigger('bill-click');
                }, this)
                .on('cash-click', function() {
                    this.trigger('cash-click');
                }, this);
        }
    }
});
