/**
 * Блок для вывода предупреждающего сообщения с/без иконки
 * @param {String} ctx.content - содержимое сообщения
 * @param {Object} [ctx.icon=''] - иконка
 * @param {String} [mods.theme='red'] - тема блока
 */
block('b-warning-message')(

    def()(function() {
        return applyNext({
            'mods.theme': this.mods.theme || 'red',
            'mods.icon': this.ctx.icon ? 'yes' : ''
        });
    }),

    content()(function() {

        return [
            this.ctx.icon && {
                elem: 'icon',
                content: this.ctx.icon
            },
            {
                elem: 'content',
                content: this.ctx.content
            }
        ];
    })
);
