block('b-wordstat')(

    elem('phrases')(

        mix()([
            {
                block: 'b-wordstat',
                elem: 'cell'
            },
            {
                block: 'b-checkboxes-group',
                js: true
            }
        ]),

        match(function() { return this.ctx.associations; }).mix()([
            {
                block: 'b-wordstat',
                elem: 'cell',
                elemMods: { with: 'associations' }
            },
            {
                block: 'b-checkboxes-group',
                js: true
            }
        ]),

        content()(function() {
            var ctx = this.ctx,
                res = [
                    {
                        elem: 'stat-header',
                        mix: [{
                            block: 'i-clearfix'
                        }]
                    },
                    {
                        elem: 'stat-body',
                        mix: { block: 'i-clearfix' },
                        phrases: ctx.phrases || ctx.associations,
                        loadMore: ctx.loadMore
                    }
                ];

            return res;
        })
    ),

    elem('stat-header').content()(function() {
        return {
            block: 'checkbox',
            mix: [{
                block: 'b-checkboxes-group',
                elem: 'item'
            }],
            text: {
                elem: 'label',
                content: [
                    {
                        elem: 'count',
                        tag: 'span',
                        mix: [{
                            block: 'b-wordstat',
                            elem: 'count'
                        }],
                        content: iget2('b-wordstat', 'pokazov-v-mesyac', 'Показов в месяц')
                    },
                    {
                        elem: 'phrase',
                        tag: 'span',
                        mix: [{
                            block: 'b-wordstat',
                            elem: 'phrase'
                        }],
                        content: iget2('b-wordstat', 'slova', 'Слова')
                    }
                ]
            }
        };
    }),

    elem('stat-body').content()(function() {
        return [
            {
                elem: 'phrase',
                phrases: this.ctx.phrases
            },
            this.ctx.loadMore && { elem: 'reload' }
        ];
    }),

    elem('phrase')(

        tag()(''),

        content()(function() {
            var res = [];

            this.ctx.phrases.forEach(function(phrase) {
                res.push({
                    block: 'checkbox',
                    mix: [{
                        block: 'b-checkboxes-group',
                        elem: 'item'
                    }],
                    checkboxAttrs: { value: phrase.phrase },
                    text: {
                        elem: 'label',
                        content: [
                            {
                                elem: 'count',
                                tag: 'span',
                                mix: [{
                                    block: 'b-wordstat',
                                    elem: 'count'
                                }],
                                content: phrase.cnt
                            },
                            {
                                elem: 'phrase',
                                tag: 'span',
                                mix: [{
                                    block: 'b-wordstat',
                                    elem: 'phrase'
                                }],
                                content: phrase.phrase
                            }
                        ]
                    }
                });
            });

            return res;
        })
    )
);
