BEM.DOM.decl('b-wordstat', {

    onSetMod: {

        loading: {

            '': function() {
                this._getInput().delMod('disabled').val('');
                this._getLoad().setMod('disabled', 'yes');
                this._getSpin('load-spin').delMod('progress');
                this._getAccept().setMod('disabled', 'yes');
            },

            start: function(modVal, modName, prev) {
                BEM.DOM.destruct(false, this.elem('stat'), true);

                this._getInput().setMod('disabled', 'yes');
                this._getLoad().setMod('disabled', 'yes');
                this._getSpin('load-spin').setMod('progress', 'yes');

                this._part = 0;
                this._loadWordstat();
            },

            completed: function(modVal, modName, prev) {
                if (prev === 'start') {
                    this._getInput().delMod('disabled');
                    this._getLoad().delMod('disabled');
                    this._getSpin('load-spin').delMod('progress');
                }

                if (prev === 'more') {
                    this._getSpin('reload-spin').delMod('progress');
                    this._nextPage ?
                        this._getButton('more').delMod('disabled') :
                        this._getButton('more').delMod('focused');
                }

            },

            more: function() {
                this._getSpin('reload-spin').setMod('progress', 'yes');
                this._getButton('more').setMod('disabled', 'yes');

                this._loadWordstat();
            },

            no: function() {
                this._getInput().delMod('disabled');
                this._getLoad().delMod('disabled');
                this._getSpin('load-spin').delMod('progress');
            }
        }
    },

    /**
     * Загрузка фраз
     * @private
     */
    _loadWordstat: function() {
        this
            ._getRequest()
            .get({
                cmd: 'wordstat',
                is_mobile: this.params.isMobile ? 1 : undefined,
                ajax: 1,
                geo: this._getGeoIds(),
                text: this._getInput().val(),
                page: this._part,
                video_advq: this.groupModel.get('content_promotion_content_type') === 'video' ? 1 : undefined,
                collections_advq: this.groupModel.get('content_promotion_content_type') === 'collection' ? 1 : undefined
            },
            this._onDataLoaded,
            { callbackCtx: this });
    },

    /**
     * Возвращает i-request_type_ajax
     * @returns {Object}
     */
    _getRequest: function() {
        return this.request || (this.request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            cache: false,
            dataType: 'json',
            type: 'POST'
        }));
    },

    /**
     * Возвращает айдишники регионов текущего баннера
     * @returns {String}
     */
    _getGeoIds: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.groupModel.get('modelId') }).get('geo');
    },

    _onDataLoaded: function(data) {
        var isPhrase = data.advq_stat.count && data.advq_stat.count != '0';

        this._nextPage = data.advq_stat.has_next_page === 'true';

        if (!this ._part++) {
            isPhrase ? this._onFirstLoad(data.advq_stat) : this._drawWordstatElement({ elem: 'error' });
        } else {
            this._onNextPartLoad(data.advq_stat.including_phrases);
        }

        this.setMod('loading', isPhrase ? 'completed' : 'no');
    },

    /**
     * Отрисовывает данные статистики
     * вызывается при отрисовке первой части
     * @param {Object} stat
     */
    _onFirstLoad: function(stat) {
        this._drawHeaders(stat.phrase, stat.count, !!stat.associations.length);

        stat.including_phrases.length &&
            this._drawWordstatElement({ elem: 'phrases', phrases: stat.including_phrases, loadMore: this._nextPage });

        stat.associations.length &&
            this._drawWordstatElement({ elem: 'phrases', associations: stat.associations, loadMore: false });

        (stat.including_phrases || stat.associations).length && this._drawWordstatElement({ elem: 'clear-wrap' });
    },

    /**
     * Отрисовывает данные статистики
     * вызывается при отрисовке следующих частей
     * @param {Array} includingPhrases
     * @private
     */
    _onNextPartLoad: function(includingPhrases) {
        if (!includingPhrases) return;

        var chekboxesGroup = this.findBlockInside('b-checkboxes-group'),
            nextPart = $(BEMHTML.apply({
                block: 'b-wordstat',
                elem: 'phrase',
                phrases: includingPhrases
            }));

        includingPhrases.length && BEM.DOM.before(this.findElem('reload'), nextPart);

        chekboxesGroup && chekboxesGroup.rearrange();
    },

    /**
     * Отрисовывает заголовки таблиц
     * @param {String} phrase фраза
     * @param {Number} count количество показов фразы
     * @param {Boolean} hasAssociations наличие ассоциаций
     */
    _drawHeaders: function(phrase, count, hasAssociations) {
        count = u.pluralize([iget2('b-wordstat', 'pokaz', 'показ'), iget2('b-wordstat', 'pokaza', 'показа'), iget2('b-wordstat', 'pokazov', 'показов')], count, '&nbsp;');

        this._drawWordstatElement({
            elem: 'headers',
            phrase: BEM.blocks['i-utils'].escapeHTML(phrase),
            count: count,
            hasAssociations: hasAssociations
        });
    },

    /**
     * Отрисовывает элемент блока
     * @param {Object} params
     */
    _drawWordstatElement: function(params) {
        params.block = 'b-wordstat';
        BEM.DOM.append(this.elem('stat'), BEMHTML.apply(params));
    },

    /**
     * Возвращает выбранные фразы
     * @returns {String[]}
     * @private
     */
    _getChoosenPhrases: function() {
        return this._getCheckboxesGroups().reduce(function(prev, current) {
            return prev.concat(current.getChecked().map(function(checkbox) {
                return checkbox.val();
            }));
        }, []);
    },

    /**
     * Обработчик события на событии change b-checkboxes-group
     * следит за выбранным фразами и кнопками «Сохранить», «Очистить»
     * @private
     */
    _onChangeGroup: function() {
        var isSelected = !!this._getChoosenPhrases().length;

        this._getAccept().toggleMod('disabled', '', 'yes', isSelected);

        this._getButton('clear').toggleMod('disabled', '', 'yes', isSelected);
    },

    /**
     * Обработчик клика по кнопке «Очистить»
     * вызывает у каждой группы чекбоксов unCheckAll()
     * @private
     */
    _onClearClick: function() {
        this._getButton('clear').delMod('focused');

        this._getCheckboxesGroups().forEach(function(group) {
            group.unCheckAll();
        });
    }

}, {

    live: function() {
        this.__base.apply(this, arguments);

        this
            .liveBindTo('more', 'click', function() {
                this.setMod('loading', 'more');
            })
            .liveBindTo('clear', 'click', function() {
                this._onClearClick();
            })
            .liveInitOnBlockInsideEvent('change', 'b-checkboxes-group', function() {
                this._onChangeGroup();
            });

    }
});
