BEM.DOM.decl({ block: 'b-wordstat', implements: 'i-outboard-controls' }, {

    onSetMod: {

        js: function() {

            this._getInput() || this._drawWordSearch();

            this.bindTo('keydown', this._onKeyDown);
        }

    },

    /**
     * Отрисовывает текстовый инпут с кнопкой «Подобрать»
     * @returns {*}
     * @private
     */
    _drawWordSearch: function() {
        var search = $(BEMHTML.apply([
            { block: 'b-wordstat', elem: 'search' },
            { block: 'b-wordstat', elem: 'stat', mix: [{ block: 'i-clearfix' }] }
        ]));

        return BEM.DOM.before(this.elem('controls'), search);
    },

    _input: null,

    _getInput: function() {
        return this._input || (this._input = this.findBlockInside('input', 'input'));
    },

    _load: null,

    _getLoad: function() {
        return this._load || (this._load = this.findBlockInside('load', 'button'));
    },

    _accept: null,

    _getAccept: function() {
        return this._accept || (this._accept = this.findBlockInside('accept', 'button'));
    },

    /**
     * Обработчик события на keydown
     * @param {Event} e
     * @private
     */
    _onKeyDown: function(e) {
        var keyCode = e.keyCode;

//      27 — Esc
        keyCode == 27 && this.declineChange();

//      13 — Enter
        if (keyCode == 13) {
            this.containsDomElem($(e.target)) && this.setMod('loading', 'start');
        }
    },

    /**
     * Возвращает spin блока
     * @param {String} name
     * @returns {BEM}
     * @private
     */
    _getSpin: function(name) {
        return this.findBlockInside(name, 'spin');
    },

    /**
     * Возвращает button блока
     * @param {String} name
     * @returns {BEM}
     * @private
     */
    _getButton: function(name) {
        return this.findBlockInside(name, 'button');
    },

    /**
     * Возвращает b-checkboxes-group
     * @returns {Array}
     * @private
     */
    _getCheckboxesGroups: function() {
        return this.findBlocksInside('b-checkboxes-group');
    },

    /**
     * Выставляет текущую модель, сбрасывает состояние блока данных статистики
     * @param {Object} params
     */
    prepareToShow: function(params) {
        this.groupModel = BEM.MODEL.getOne({ name: this.params.modelName || 'm-group', id: params.adgroupId });

        this._reset();
    },

    /**
     * Обработчик клика по кнопке «Сохранить»
     * обновляет модель выбранными фразами
     */
    provideData: function() {
        this.groupModel.set(
            'new_phrases',
            $.unique(this.groupModel.get('new_phrases').concat(this._getChoosenPhrases())));
    },

    /**
     * Обработчик клика по кнопке «Отмена»
     */
    declineChange: function() {
        this._reset();
    },

    /**
     * Сбрасывает состояние блока,
     * @param {Object} [params]
     */
    _reset: function(params) {
        params = params || {};
        this._geo = params.geo;
        this._part = 0;

        this._getCheckboxesGroups().forEach(function(group) {
            group.dropCachedItems();
        });

        this.delMod('loading');

        BEM.DOM.destruct(false, this.elem('stat'), true);
    },

    _part: null

}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('change', 'input', function() {
                this._getLoad().toggleMod('disabled', '', 'yes', !!this._getInput().val());
            })
            .liveBindTo('load', 'click', function() {
                this.setMod('loading', 'start');
            });
    }
});
