block('b-worktime')(
    addJs()(true),

    content()(function() {
        var hours = '00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24'.split(' '),
            minutes = '00 15 30 45'.split(' ');

        return [
            {
                elem: 'wrapper',
                content: [
                    {
                        tag: 'span',
                        elem: 'hour-from-wrap',
                        content: [
                            {
                                block: 'select',
                                js: {
                                    rows: 6
                                },
                                mods: {
                                    disabled: this.ctx.disabled ? 'yes' : '',
                                    layout: 'worktime'
                                },
                                mix: [{
                                    block: 'b-worktime',
                                    elem: 'hour-from'
                                }],
                                content: [
                                    {
                                        block: 'button',
                                        content: this.ctx.hourFrom
                                    },
                                    {
                                        elem: 'control',
                                        content: hours.map(function(val) {
                                            var attrs = {
                                                value: val
                                            };

                                            if (this.ctx.hourFrom == val) attrs.selected = 'yes';

                                            return {
                                                block: 'select',
                                                elem: 'option',
                                                attrs: attrs,
                                                content: val
                                            };
                                        }, this)
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        tag: 'span',
                        content: '&nbsp;:&nbsp;'
                    },
                    {
                        tag: 'span',
                        elem: 'min-from-wrap',
                        content: {
                            block: 'select',
                            mods: {
                                disabled: this.ctx.disabled ? 'yes' : ''
                            },
                            mix: [{
                                block: 'b-worktime',
                                elem: 'min-from'
                            }],
                            content: [
                                {
                                    block: 'button',
                                    content: this.ctx.minFrom
                                },
                                {
                                    elem: 'control',
                                    content: minutes.map(function(val, i) {
                                        var attrs = {
                                            value: val
                                        };

                                        if (this.ctx.minFrom == val) attrs.selected = 'yes';

                                        return {
                                            block: 'select',
                                            elem: 'option',
                                            attrs: attrs,
                                            content: val
                                        };
                                    }, this)
                                }
                            ]
                        }
                    },
                    {
                        tag: 'span',
                        content: '&nbsp;&mdash;&nbsp;'
                    },
                    {

                        tag: 'span',
                        elem: 'hour-to-wrap',
                        content: {
                            block: 'select',
                            js: {
                                rows: 6
                            },
                            mods: {
                                disabled: this.ctx.disabled ? 'yes' : '',
                                layout: 'worktime'
                            },
                            mix: [{
                                block: 'b-worktime',
                                elem: 'hour-to'
                            }],
                            content: [
                                {
                                    block: 'button',
                                    content: this.ctx.hourTo
                                },
                                {
                                    elem: 'control',
                                    content: hours.map(function(val, i) {
                                        var attrs = {
                                            value: val
                                        };

                                        if (this.ctx.hourTo == val) attrs.selected = 'yes';

                                        return {
                                            block: 'select',
                                            elem: 'option',
                                            attrs: attrs,
                                            content: val
                                        };
                                    }, this)
                                }
                            ]
                        }
                    },
                    {
                        tag: 'span',
                        content: '&nbsp;:&nbsp;'
                    },
                    {
                        tag: 'span',
                        elem: 'min-to-wrap',
                        content: {
                            block: 'select',
                            mods: {
                                disabled: this.ctx.disabled ? 'yes' : ''
                            },
                            mix: [{
                                block: 'b-worktime',
                                elem: 'min-to'
                            }],
                            content: [
                                {
                                    block: 'button',
                                    content: this.ctx.minTo
                                },
                                {
                                    elem: 'control',
                                    content: minutes.map(function(val, i) {
                                        var attrs = {
                                            value: val
                                        };

                                        if (this.ctx.minTo == val) attrs.selected = 'yes';

                                        return {
                                            block: 'select',
                                            elem: 'option',
                                            attrs: attrs,
                                            content: val
                                        };
                                    }, this)
                                }
                            ]
                        }

                    }
                ]
            },
            {
                block: 'link',
                mods: {
                    pseudo: 'yes',
                    theme: 'pseudo'
                },
                mix: [
                    {
                        block: 'b-worktime',
                        elem: 'all-day',
                        elemMods: { hidden: this.ctx.disabled ? 'yes' : 'no' }
                    }
                ],
                js: true,
                content: iget2('b-worktime', 'kruglosutochno', 'круглосуточно')
            }
        ];
    })
);
