BEM.DOM.decl('b-worktime', {
    onSetMod: {
        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                hourFrom: 'select on hour-from',
                minFrom: 'select on min-from',
                hourTo: 'select on hour-to',
                minTo: 'select on min-to'
            });

            ['hourFrom', 'hourTo', 'minFrom', 'minTo'].forEach(function(name) {
                this[name].on('change', { name: name }, this.onTimeChanged, this);
            }, this);

            this.bindTo('all-day', 'click', this.setAllDay);
        }
    },

    /**
     * Устанавливает в качестве времени "круглосуточно"
     * @returns {BEM}
     */
    setAllDay: function() {
        this.setAllTime({
            hourFrom: '00',
            hourTo: '24',
            minFrom: '00',
            minTo: '00'
        });

        return this;
    },

    /**
     * Изменился один из контролов времени
     * @param {Object} e
     * @param {Object} e.data
     * @param {String} e.data.name - имя контрола, который изменился
     * @returns {BEM}
     */
    onTimeChanged: function(e) {
        var name = e.data.name;

        this.trigger('change', { name: name, val: this[name].val() });

        return this;
    },

    /**
     * Устанавливает контролу времени заданное значение
     * @param {String} name имя контрола
     * @param {String} val значение контрола
     * @returns {BEM}
     */
    setTime: function(name, val) {
        var value = val.toString();
        this[name].val(value.length > 1 ? value : '0' + value);

        return this;
    },

    /**
     * Установить заданное время
     * @param {Object} time
     * @param {String} time.hourTo
     * @param {String} time.minTo
     * @param {String} time.hourFrom
     * @param {String} time.minFrom
     * @returns {BEM}
     */
    setAllTime: function(time) {
        ['hourFrom', 'hourTo', 'minFrom', 'minTo'].forEach(function(name) {
            this.setTime(name, time[name]);
        }, this);

        return this;

    },

    /**
     * Возвращает значение контрола времени
     * @returns {Array}
     */
    getAllTime: function() {
        return ['hourFrom', 'hourTo', 'minFrom', 'minTo'].map(function(name) {
            return this[name].val();
        }, this);
    }
});
