block('b-xls-history')(

    content()(function() {
        return [
            (!this.ctx.exported.length && !this.ctx.imported.length) && {
                elem: 'empty-content'
            },
            !!this.ctx.exported.length && [
                {
                    elem: 'header',
                    content: iget2('b-xls-history', 'vygruzka', 'Выгрузка')
                },
                {
                    elem: 'table',
                    rows: this.ctx.exported,
                    columns: [
                        {
                            key: 'logdate',
                            title: iget2('b-xls-history', 'data', 'Дата')
                        },
                        {
                            key: 'cid',
                            title: iget2('b-xls-history', 'no-kampanii', '№ кампании')
                        },
                        {
                            title: iget2('b-xls-history', 'deystviya', 'Действия'),
                            sortDisable: true,
                            ctx: this.ctx,
                            transformData: function(row) {
                                var login = this.ctx.login,
                                    actions = [];

                                this.ctx.allow.download &&
                                    actions.push({
                                        caption: iget2('b-xls-history', 'skachat', 'Скачать'),
                                        cmd: 'exportCampXLS'
                                    });

                                this.ctx.allow.remove &&
                                    actions.push({
                                        caption: iget2('b-xls-history', 'udalit', 'Удалить'),
                                        cmd: 'dropCampXLS',
                                        tab: this.ctx.tab
                                    });

                                return actions.map(function(link) {
                                    return {
                                        block: 'link',
                                        mix: [{
                                            block: 'b-xls-history',
                                            elem: 'action-link'
                                        }],
                                        content: link.caption,
                                        url: u.formatUrl({
                                            path: 'registered/' + (row.file_for_url || row.cid + '.xls'),
                                            query: {
                                                cmd: link.cmd,
                                                cid: row.cid,
                                                hash: row.half_md5_hash || row.md5_hex,
                                                ulogin: login,
                                                tab: link.tab
                                            }
                                        })
                                    };
                                });
                            }
                        }
                    ]
                }
            ],

            !!this.ctx.imported.length && [
                {
                    elem: 'header',
                    content: iget2('b-xls-history', 'zagruzka', 'Загрузка')
                },
                {
                    elem: 'table',
                    rows: this.ctx.imported,
                    columns: [
                        {
                            key: 'logdate',
                            title: iget2('b-xls-history', 'data', 'Дата')
                        },
                        {
                            key: 'cid',
                            title: iget2('b-xls-history', 'no-kampanii', '№ кампании')
                        },
                        {
                            title: iget2('b-xls-history', 'status-zagruzki', 'Статус загрузки'),
                            sortDisable: true,
                            ctx: this.ctx,
                            transformData: function(row) {
                                var statuses = {
                                    success: iget2('b-xls-history', 'uspeshno', 'Успешно'),
                                    process: [iget2('b-xls-history', 'obrabatyvaetsya', 'Обрабатывается'), '&hellip;'],
                                    fail: [
                                        iget2('b-xls-history', 'oshibka-zagruzki-izobrazheniy', 'Ошибка загрузки изображений'),
                                        '&nbsp;',
                                        {
                                            block: 'link',
                                            content: ['(', iget2('b-xls-history', 'otchet', 'отчет'), ')'],
                                            url: u.formatUrl({
                                                path: 'registered/' + row.cid + '_errors.xls',
                                                query: {
                                                    cmd: 'getImportedCampXlsReport',
                                                    cid: row.cid,
                                                    xls_id: row.xls_id,
                                                    ulogin: u.escapeHTML(this.ctx.login)
                                                }
                                            })
                                        }
                                    ]
                                };

                                return statuses[row.status] || '';
                            }
                        },
                        {
                            title: iget2('b-xls-history', 'deystviya', 'Действия'),
                            sortDisable: true,
                            ctx: this.ctx,
                            transformData: function(row) {
                                var login = this.ctx.login,
                                    actions = [];

                                this.ctx.allow.download &&
                                    actions.push({
                                        caption: iget2('b-xls-history', 'skachat', 'Скачать'),
                                        cmd: 'getImportedCampXls'
                                    });

                                this.ctx.allow.remove &&
                                    actions.push({
                                        caption: iget2('b-xls-history', 'udalit', 'Удалить'),
                                        cmd: 'dropImportedCampXls',
                                        tab: this.ctx.tab
                                    });

                                return actions.map(function(link) {
                                    var query = {
                                        cmd: link.cmd,
                                        cid: row.cid,
                                        ulogin: login,
                                        tab: link.tab
                                    };

                                    query.hash = row.md5_hex;

                                    return {
                                        block: 'link',
                                        mix: [{
                                            block: 'b-xls-history',
                                            elem: 'action-link'
                                        }],
                                        content: link.caption,
                                        url: u.formatUrl({
                                            path: 'registered/' + (row.file_for_url || row.cid + '.xls'),
                                            query: query
                                        })
                                    };
                                });
                            }
                        }
                    ]
                }
            ]
        ];
    }),

    elem('empty-content').content()(function() {
        return iget2('b-xls-history', 'istoriya-raboty-s-xls', 'История работы с XLS/XLSX файлами отсутствует');
    })
);
