(function() {
    var plansDataF = function(iget2) {
        return [
            {
                price: 3000,
                description: iget2('b-ya-agency-promo-pricing', 'za-nastroyku-pervoy-kampanii', 'За настройку первой кампании (включая НДС)'),
                service: iget2('b-ya-agency-promo-pricing', 'minimalnyy-paket-br-dlya', 'Минимальный пакет<br>Для рекламы 1-2 товаров/услуг'),
                hintText: iget2('b-ya-agency-promo-pricing', 'nastroim-kampanii-na-poisk', 'Настроим кампании на поиск и сети (РСЯ)'),
                goalId: 'SETUPSERV_PRICE_SELECT_MIN'
            },
            {
                price: 5000,
                description: iget2('b-ya-agency-promo-pricing', 'za-nastroyku-pervoy-kampanii', 'За настройку первой кампании (включая НДС)'),
                service: iget2(
                    'b-ya-agency-promo-pricing',
                    'bazovyy-paket-br-dlya',
                    'Базовый пакет<br>Для рекламы 3-10 товаров/услуг или более полного охвата запросов по некоторым из них'
                ),
                hintText: iget2(
                    'b-ya-agency-promo-pricing',
                    'nastroim-kampanii-na-poisk-106',
                    'Настроим кампании на поиск и сети (РСЯ)<br>+ Настроим ретаргетинг'
                ),
                goalId: 'SETUPSERV_PRICE_SELECT_BASE'
            },
            {
                price: 10000,
                description: iget2('b-ya-agency-promo-pricing', 'za-nastroyku-pervoy-kampanii', 'За настройку первой кампании (включая НДС)'),
                service: iget2(
                    'b-ya-agency-promo-pricing',
                    'rasshirennyy-paket-br-dlya',
                    'Расширенный пакет<br>Для рекламы 11-30 товаров/услуг или более полного охвата запросов по некоторым из них'
                ),
                hintText: iget2(
                    'b-ya-agency-promo-pricing',
                    'nastroim-kampanii-na-poisk-107',
                    'Настроим кампании на поиск и сети (РСЯ)<br>+ Настроим ретаргетинг<br>+ Поможем с настройкой Яндекс.Метрики'
                ),
                goalId: 'SETUPSERV_PRICE_SELECT_EXTEND'
            }
        ];
    };

    block('b-ya-agency-promo-pricing')(
        js()(function() {
            return {
                plansData: plansDataF(iget2),
                currentItem: this.ctx.currentItem || 1
            };
        }),

        content()(function() {
            return [
                {
                    elem: 'content',
                    currentItem: this.ctx.currentItem || 1
                },
                applyNext()
            ];
        }),

        elem('content').content()(function() {
            var plansData = plansDataF(iget2),
                currentItem = this.ctx.currentItem;

            return [
                {
                    elem: 'price',
                    content: iget2('b-ya-agency-promo-pricing', 'price-asterisk', '{price} ₽{asterisk}', {
                        price: function() {
                            return u.numberFormatter.format(plansData[currentItem - 1].price, { precision: 0 });
                        }(),

                        asterisk: function(content) {
                            return {
                                elem: 'asterisk',
                                tag: 'span',
                                content: content
                            }
                        }(iget2('b-ya-agency-promo-pricing', 'price-asterisk-param-asterisk', '*')),

                        context: 'asterisk - *'
                    })
                },
                {
                    elem: 'price-description',
                    content: plansData[currentItem - 1].description
                },
                {
                    elem: 'slider',
                    currentItem: currentItem
                },
                {
                    elem: 'notice',
                    content: iget2(
                        'b-ya-agency-promo-pricing',
                        'polnaya-informaciya-o-stoimosti',
                        '* Полная информация о стоимости оказания услуги по настройке Директа {link}.',
                        {
                            link: function(text) {
                                return {
                                    block: 'link',
                                    mix: {
                                        block: 'b-metrika',
                                        js: { goal: 'SETUPSERV_FULL_PRICES_LINK', counter: '34' }
                                    },
                                    url: u.getLegalUrl('yandex_direct_set_up_service_prices/index.html'),
                                    content: text
                                };
                            }(iget2('b-ya-agency-promo-pricing', 'polnaya-informaciya-o-stoimosti-param-link', 'здесь')),

                            context: 'link - здесь'
                        }
                    )
                }
            ];
        }),

        elem('slider').content()(function() {
            var currentItemIndex = this.ctx.currentItem - 1,
                plansData = plansDataF(iget2);

            return plansData.map(function(item, i, collection) {
                var res = [],
                    planData = plansData[i];

                if (i !== 0) {
                    res.push({
                        elem: 'slider-connector',
                        elemMods: {
                            state: currentItemIndex >= i ? 'active' : 'inactive'
                        }
                    });
                }

                res.push({
                    elem: 'slider-pin',
                    mix: {
                        block: 'b-metrika',
                        js: { goal: planData.goalId, counter: '34' }
                    },
                    js: { plan: i + 1 },
                    elemMods: {
                        state: currentItemIndex === i ?
                            'current' :
                            currentItemIndex > i ? 'selected' : 'inactive'
                    },
                    content: [
                        planData.hintText && {
                            elem: 'hint',
                            elemMods: { plan: i + 1 },
                            content: planData.hintText
                        },
                        {
                            elem: 'description',
                            mix: {
                                block: 'b-metrika',
                                js: { goal: planData.goalId, counter: '34' }
                            },
                            content: planData.service
                        }
                    ]
                });

                return res;
            });
        })
    );
}());
