BEM.DOM.decl({ block: 'b-ya-dialog-popup-adapter' }, {
    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _btn: 'button on btn',
                _hidden: 'b-hidden on hidden',
                _dialogId: 'dialog-id'
            });

            this._btn.setMod('disabled', '');

            this._campaign = BEM.MODEL.getOne(this.params.modelParams);

            this._setDialog({
                skillId: this._campaign.get('dialog_id'),
                name: this._campaign.get('dialog_name')
            });

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._subscriptionManager.on(this._btn, 'click', this._showPopup, this);

            this._initPopup();
        }
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        return this.__base.apply(this, arguments);
    },

    _showPopup: function() {
        this._popupContent.init({
            selectedId: this._campaign.get('dialog_id'),
            popup: this._popupDecorator
        });
        this._popupDecorator.show();
    },

    _initPopup: function() {
        this._popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $);
        this._popupContent = this._popupDecorator.setPopupContent({
            block: 'b-ya-dialog-popup',
            modelParams: this.params.modelParams
        });

        this._subscriptionManager.wrap(this._popupDecorator)
            .on('close-blocked', function() {
                BEM.blocks['b-user-dialog'].confirm({
                    message: iget2('b-ya-dialog-popup-adapter', 'changes-will-not-save', 'Изменения не будут сохранены. Продолжить?'),
                    onConfirm: function() {
                        this._popupDecorator.hide({ force: true });
                    }.bind(this)
                });
            }, this);

        this._subscriptionManager.wrap(this._popupContent)
            .on('cancel', function() {
                this._popupDecorator.hide({ force: true });
            }, this)
            .on('save', function(event, dialog) {
                this._campaign.set('dialog_id', dialog.skillId || '');
                this._campaign.set('dialog_name', dialog.name || '');

                this._setDialog(dialog);

                this._popupDecorator.hide({ force: true });
            }, this);
    },

    _setDialog: function(dialog) {
        BEM.DOM.update(this._dialogId, u.escapeHTML(dialog.name || dialog.skillId));

        this.setMod(this._dialogId, 'empty', dialog.skillId ? '' : 'yes' );

        this._btn.setText(
            dialog.skillId ?
            iget2('b-ya-dialog-popup-adapter', 'change', 'Изменить') :
            iget2('b-ya-dialog-popup-adapter', 'add', 'Добавить')
        );

        this._hidden.domElem[0].setAttribute('value', dialog.skillId || '');
    }

});
