block('b-ya-dialog-popup')(
    js()(function() {
        return {
            modelParams: this.ctx.modelParams
        };
    }),

    content()(function() {
        return [
            {
                elem: 'head',
                mix: { block: 'b-modal-popup-decorator', elem: 'header' }
            },
            {
                elem: 'body',
                mix: { block: 'b-modal-popup-decorator', elem: 'body' },
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' }
            }
        ];
    }),

    elem('head').content()(function() {
        return [
            {
                elem: 'header',
                content: [
                    iget2('b-ya-dialog-popup', 'header', 'Чат с оператором'),
                    {
                        block: 'b-help-link',
                        mix: [
                            { block: 'b-ya-dialog-popup', elem: 'help-link' }
                        ],
                        mods: {
                            type: 'modal'
                        },
                        url: u.getHelpUrl('chats-dialogs')
                    }
                ]
            },
            {
                elem: 'description',
                content: [
                    iget2('b-ya-dialog-popup', 'description', 'Выберите подходящий чат в списке или укажите его идентификатор. Создать или отредактировать чаты можно на странице '),
                    {
                        block: 'link',
                        url: 'https://dialogs.yandex.ru/developer/',
                        attrs: {
                            target: '_blank'
                        },
                        content: iget2('b-ya-dialog-popup', 'dialogs-link', 'Яндекс.Диалогов')
                    },
                    '.'
                ]
            }
        ];
    }),

    elem('body').content()(function() {
        return [
            {
                block: 'b-ya-dialog-selector'
            },
            {
                elem: 'add-dialog',
                content: {
                    block: 'b-add-ya-dialog-popup-adapter',
                }
            }
        ]
    }),

    elem('footer').content()(function() {
        return [
            {
                block: 'button2',
                mods: {
                    theme: 'action',
                    size: 's',
                    disabled: 'yes'
                },
                mix: [
                    { block: 'b-ya-dialog-popup', elem: 'save-btn' },
                    { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                ],
                text: iget2('b-ya-dialog-popup', 'save', 'Сохранить')
            },
            {
                block: 'button2',
                mods: {
                    theme: 'normal',
                    size: 's'
                },
                mix: [
                    { block: 'b-ya-dialog-popup', elem: 'cancel-btn' },
                    { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                ],
                text: iget2('b-ya-dialog-popup', 'cancel', 'Отмена')
            }
        ];
    })
);
