BEM.DOM.decl({ block: 'b-ya-dialog-popup', implements: 'i-modal-popup-inner-block-interface' }, {

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(!!this._isChangedValue);

        return deferred.promise();
    },

    _initialValue: null,

    /**
     * Инициализация блока
     * @param {Object} params
     * @param {string} params.selectedId
     * @param {BEM.DOM} params.popup
     * @returns {BEM.DOM}
     */
    init: function(params) {
        this._getYaDialogSelector().init(params.selectedId);
        this._getYaDialogSelector().setOuterPopup(params.popup);
        this._initialValue = params.selectedId;
        this._getAddYaDialogPopupAdapter().setDialogsModel(this._getDialogsModel());

        return this;
    },

    _isChangedValue: null,

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('save-btn').is(e.block.domElem) && this._onSaveClick(e, data);
        this.elem('cancel-btn').is(e.block.domElem) && this._onCancelClick(e, data);
    },

    _saveButton: null,

    /**
     * Обработчик клика по любой кнопке "Сохранить"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onSaveClick: function(e, data) {
        this._saveButton || (this._saveButton = e.block);

        var selectedDialog = this._getYaDialogSelector().val();

        this.trigger('save', selectedDialog);
    },

    /**
     * Возвращает инстанс кнопки "Сохранить"
     * @private
     */
    _getSaveButton: function() {
        return this._saveButton || (this._saveButton = this.findBlockOn('save-btn', 'button2'));
    },

    /**
     * Обработчик клика по любой кнопке "Отмена"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onCancelClick: function(e, data) {
        this.trigger('cancel');
    },

    _yaDialogSelector: null,

    /**
     * Возвращает инстанс блока выбора чата
     * @private
     */
    _getYaDialogSelector: function() {
        return this._yaDialogSelector || (this._yaDialogSelector = this.findBlockInside('body', 'b-ya-dialog-selector'));
    },

    /**
     * Обработчик изменения блока выбора чата
     * @param {jQuery.Event} e
     * @param {{val: string}} data – ID выбранного чата
     * @private
     */
    _onYaDialogSelectorChange: function(e, data) {
        this._yaDialogSelector || (this._yaDialogSelector = e.block);

        this._isChangedValue = (this._initialValue || data.val) && this._initialValue !== data.val;

        this._getSaveButton().setMod('disabled', this._isChangedValue ? '' : 'yes');
    },

    /**
     * Возвращает инстанс адаптера попапа добавления нового чата
     * @private
     */
    _getAddYaDialogPopupAdapter: function() {
        return this._addYaDialogPopupAdapter ||
            (this._addYaDialogPopupAdapter = this.findBlockInside('body', 'b-add-ya-dialog-popup-adapter'));
    },

    /**
     * Возвращает инстанс модели диалогов из селектора диалогов
     * @private
     */
    _getDialogsModel: function() {
        return this._getYaDialogSelector().getDialogsModel();
    },

    destruct: function() {
        BEM.DOM.destruct(this.domElem, true); // чистим внутренности

        return this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button2', function(e, data) {
                this._onButtonClick(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'b-ya-dialog-selector', function(e, data) {
                this._onYaDialogSelectorChange(e, data);
            });

        return false;
    }

});
