BEM.DOM.decl('b-ya-dialog-selector', {

    onSetMod: {

        js: function() {
            this._model = BEM.MODEL.create('b-ya-dialog-selector');
            this._subMan = BEM.create('i-subscription-manager');

            this._bChooser = this.findBlockOn('content', 'b-chooser');
            this._inputSearch = this.findBlockOn('search-input', 'input');

            this._initEvents();
        },

        loading: {
            yes: function() {
                BEM.DOM.append(this.elem('content'), BEMHTML.apply({
                    block: this.__self.getName(),
                    elem: 'loader'
                }));
            },

            '': function() {
                BEM.DOM.destruct(this.findElem('loader'));
            }
        }
    },

    /**
     * Подписывает блок на события
     * @private
     */
    _initEvents: function() {
        this._subMan.wrap(this._model)
            .on('list', 'add', this._onCreateItem, this);

        this._subMan
            .on(this._bChooser, 'change', this._onSelectedDialogChange, this);
    },

    /**
     * Обработчик на создание модели диалога
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {BEM.MODEL} data.model
     * @private
     */
    _onCreateItem: function(e, data) {
        var dialogModel = data.model;

        // Флаг resetChooser выставляется после добавления нового диалога.
        // Блок b-chooser очищается один раз при добавлении первого диалога из нового отсортированного списка
        if (this._model.get('resetChooser')) {
            this._bChooser.removeAll();
            // диалог добавлен, в списке точно есть элементы
            this.delMod('empty');
            this._model.set('resetChooser', false);
        }

        this._bChooser.add(this._generateChooserItem(dialogModel));

        var selectedDialog = this._model.get('selected').get('skillId');
        selectedDialog === dialogModel.get('skillId') && this._bChooser.check(selectedDialog);

        // т.к. в методе `add` блока `b-chooser` не зашита логика обновления поиска, после добавления элемента,
        // делаем это следующим способом
        this._inputSearch.trigger('change');
    },

    _onSelectedDialogChange: function() {
        this.trigger('change', { val: this._bChooser.val() });
    },

    /**
     * Запрашивает и обрабатывает чаты с бэка
     * @param {string | undefined} selectedId - ID чата, выбранного в кампании
     */
    init: function(selectedId) {
        this.setMod('loading', 'yes');
        // Очищаем инпут
        this._inputSearch.val('');

        // Если в модели уже есть чаты – инициализация не нужна
        if (this._model.get('hasAvailable')) {
            this.delMod('loading');
            return;
        }

        this._model.set('inited', false);

        u['b-ya-dialog-popup'].getDialogs(u.consts('ulogin'))
            .then(function(dialogs) {
                dialogs = dialogs || [];

                // На всякий пожарный отсортировать прибывшие чаты по названию
                dialogs.sort(function(a, b) {
                    if (a.name > b.name) {
                        return 1;
                    } else if (a.name < b.name) {
                        return -1;
                    }

                    return 0;
                });

                this._initSelector(dialogs.concat({
                    // Дефолтный элемент, добавляется в конец списка чатов
                    name: iget2('b-ya-dialog-selector', 'use-no-chat-item', 'Не использовать чат'),
                    skillId: u['b-ya-dialog-popup'].USE_NO_DIALOGS_ID,
                    isActive: true
                }), selectedId);

                this.delMod('loading');
                // Высота попапа после загрузки чатов меняется, нужно выровнять по-вертикали
                this._outerPopup.repaint();

            }.bind(this))
            .catch(function(e) {
                this._alertError(iget2('b-ya-dialog-selector', 'proizoshla-oshibka', 'Произошла ошибка.'), true);
                this.delMod('loading');
            }.bind(this));
    },

    /**
     * Заполняет модель данными и отключает прелоадер
     * @param {Object[]} dialogs - чаты для обновления можели
     * @param {string | undefined} selectedId - ID чата, выбранного в кампании
     * @private
     */
    _initSelector: function(dialogs, selectedId) {

        // Если столько дефолтный элемет 'Не использовать чат'
        if (dialogs.length === 1) {
            this.setMod('empty', 'yes');
        }

        var selectedDialog = dialogs.filter(function(dialog) {
            return dialog.skillId === selectedId;
        })[0];

        this._model
            .set('list', dialogs)
            .set('inited', true)
            .fix();

        // Если есть дефолтный выбор – применить вручную к b-chooser
        // и обновить выбранный чат в модели
        selectedDialog && this._bChooser.check(selectedId) && this._model.set('selected', {
            skillId: selectedDialog.skillId,
            name: selectedDialog.name,
            isActive: selectedDialog.isActive
        });

        this._inputSearch.setMod('focused', 'yes');
    },

    /**
     * Формирует bemjson для элемента блока `b-chooser`
     * @param {BEM.MODEL} dialogModel
     * @returns {Object}
     * @private
     */
    _generateChooserItem: function(dialogModel) {
        var skillId = dialogModel.get('skillId'),
            dialogName = dialogModel.get('name'),
            isActive = dialogModel.get('isActive');

        return {
            elemMods: {
                disabled: isActive ? '' : 'yes'
            },
            js: {
                search: { dialogName: dialogName, skillId: skillId }
            },
            name: skillId,
            content: {
                block: 'b-ya-dialog-selector-item',
                mods: {
                    'no-dialog': skillId === u['b-ya-dialog-popup'].USE_NO_DIALOGS_ID ? 'yes' : '',
                    disabled: isActive ? '' : 'yes'
                },
                skillId: skillId,
                title: dialogName,
                isActive: isActive
            }
        };
    },

    /**
     * Возвращает выбранный чат
     * @returns {{skillId: string, name: string}}
     */
    val: function() {
        var selectedId = this._bChooser.val(),
            selectedDialogModel;

        if (!selectedId || selectedId === u['b-ya-dialog-popup'].USE_NO_DIALOGS_ID) return false;

        selectedDialogModel = this._model.getDialogById(selectedId);

        return {
            skillId: selectedDialogModel.get('skillId'),
            name: selectedDialogModel.get('name')
        };
    },

    _outerPopup: undefined,

    /**
     * Устанавливает ссылку на родительский попап.
     * @param {BEM.DOM} popup
     */
    setOuterPopup: function(popup) {
        this._outerPopup = popup;
    },

    /**
     * Возвращает модель чатов
     * @returns {BEM.MODEL}
     */
    getDialogsModel: function() {
        return this._model;
    },

    /**
     * Отображает сообщение в диалоговом окне
     * @param {String} message Сообщение
     * @param {Boolean} [needClose] Флаг, при котором по клику на "Ок" и "Отмена" в диалоговом окне закроется попап (при наличи) снаружи блока
     * @private
     */
    _alertError: function(message, needClose) {
        var popup = this._outerPopup,
            callBack = (popup && needClose) ?
                function() { popup.hide() } :
                undefined;

        BEM.blocks['b-confirm'].open({
            type: 'alert',
            message: message,
            fromPopup: popup,
            onYes: callBack,
            onNo: callBack
        }, this);
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();
        this._model.destruct();

        BEM.DOM.destruct(this.domElem, true); // чистим внутренности

        this.__base.apply(this, arguments);
    }

});
