BEM.MODEL.decl('b-ya-dialog-selector', {

    // Полный список чатов
    list: {
        type: 'models-list',
        modelName: 'b-ya-dialog-selector-item'
    },

    // Выбранный чат
    selected: {
        type: 'model',
        modelName: 'b-ya-dialog-selector-item'
    },

    // Наличие доступных для выбора чатов
    hasAvailable: {
        type: 'boolean',
        dependsFrom: 'list',
        calculate: function() {
            return !!this.get('list', 'raw').length
        }
    },

    // Флаг готовности модели
    inited: {
        type: 'boolean',
        default: false
    },

    // Флаг для обновления b-chooser перед изменением списка чатов
    resetChooser: {
        type: 'boolean',
        default: false
    }

}, {

    getDialogById: function(dialogId) {
        return this.get('list').getById(dialogId);
    },

    /**
     * Добавляет новый чат в список, сортирует чаты по имени,
     * в конец списка добавляет элемент, которые позволяет выбрать чат позднее;
     * помечает новый чат как выбранный, если он активен;
     * выставляет флаг 'resetChooser', чтобы удалить все чаты из селектора
     * и заменить отсортированными.
     * @param {Object} dialog - новый чат
     */
    addNewDialog: function(dialog) {
        var rawList = this.getFixedValue().list,
            isDuplicate,
            list,
            noDialogItem;

        isDuplicate = u._.some(rawList, function(item) {
            return item.skillId === dialog.skillId;
        });

        if (isDuplicate) {
            this.set('resetChooser', false);
            this.fix();
            return false;
        }

        this.set('resetChooser', true);

        dialog.isActive && this.set('selected', {
            skillId: dialog.skillId,
            name: dialog.name,
            isActive: dialog.isActive
        });

        noDialogItem = rawList.find(function(el) {
            return el.skillId === u['b-ya-dialog-popup'].USE_NO_DIALOGS_ID;
        });

        list = rawList.filter(function(item) {
            return item.skillId !== u['b-ya-dialog-popup'].USE_NO_DIALOGS_ID;
        });

        list.push({
            skillId: dialog.skillId,
            name: dialog.name,
            isActive: dialog.isActive
        });

        list.sort(function(a, b) {
            if (a.name > b.name) {
                return 1;
            } else if (a.name < b.name) {
                return -1;
            }

            return 0;
        });

        list.push(noDialogItem);

        this.set('list', list);
        this.fix();

        return true;
    }

});
