block('b-ya-money-payment')(

    addJs()(function() {
        return {
            cuRate: this.data.conv_unit_rate,
            currency: this.data.work_currency,
            nds: this.data.client_nds
        };
    }),

    content()(function() {

        var data = this.data,
            hiddenInputs = {
                yamoney: 1,
                cmd: 'payforall',
                sort: data.FORM.sort,
                reverse: data.FORM.reverse
            };

        data.uid_par && (hiddenInputs[data.uid_par.key] = data.uid_par.value);

        return {
            block: 'b-layout-form',
            action: data.SCRIPT,
            method: 'POST',
            mixes: {
                submit: [{
                    block: 'b-ya-money-payment',
                    elem: 'submit'
                }]
            },
            hiddenInputs: Object.keys(hiddenInputs).map(function(name) {
                return {
                    name: name,
                    value: hiddenInputs[name]
                };
            }),
            rows: [{
                block: 'b-layout-table',
                content: (applyCtx({ elem: 'table-head' }) || [])
                    .concat(applyCtx({ elem: 'table-body' }))
                    .concat(applyCtx({ elem: 'table-foot' }))
            }],
            submit: {
                block: 'button',
                type: 'submit',
                mods: { theme: 'action' },
                content: iget2('b-ya-money-payment', 'oplatit', 'Оплатить')
            }
        };
    }),

    elem('table-head').def()(function() {
        var data = this.data,
            defaultColumn = 'name';

        return [
            {
                elem: 'thead',
                mix: [{
                    block: 'b-ya-money-payment',
                    elem: 'thead'
                }],
                content: [
                    {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                mix: [
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'td'
                                    },
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'head-cell'
                                    }
                                ],
                                content: '&nbsp;'
                            },
                            {
                                elem: 'cell',
                                mix: [
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'td'
                                    },
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'head-cell'
                                    }
                                ],
                                content: u.table.getSortHeaderLink({
                                    col: 'name',
                                    caption: iget2('b-ya-money-payment', 'kampaniya', 'Кампания'),
                                    defCol: defaultColumn,
                                    script: data.script
                                },
                                        data.FORM) +
                                    ' / ' +
                                    u.table.getSortHeaderLink({
                                        col: 'cid',
                                        caption: '&#8470;',
                                        defCol: defaultColumn,
                                        script: data.script
                                    },
                                        data.FORM)
                            },
                            {
                                elem: 'cell',
                                mix: [
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'td'
                                    },
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'head-cell'
                                    }
                                ],
                                content: u.table.getSortHeaderLink({
                                    col: 'status.text',
                                    caption: iget2('b-ya-money-payment', 'sostoyanie', 'Состояние'),
                                    defCol: defaultColumn,
                                    script: data.script
                                },
                                    data.FORM)
                            },
                            {
                                elem: 'cell',
                                mix: [
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'td',
                                        elemMods: {
                                            align: 'right'
                                        }
                                    },
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'head-cell'
                                    }
                                ],
                                content: u.table.getSortHeaderLink({
                                    col: 'sum',
                                    caption: iget2('b-ya-money-payment', 'zachisleno-s', 'Зачислено, {foo}', {
                                        foo: u.currencies.getName(data.work_currency)
                                    }),
                                    defCol: defaultColumn,
                                    script: data.script
                                },
                                    data.FORM)
                            },
                            {
                                elem: 'cell',
                                mix: [
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'td',
                                        elemMods: {
                                            align: 'right'
                                        }
                                    },
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'head-cell'
                                    }
                                ],
                                content: u.table.getSortHeaderLink({
                                    col: 'sum_rest',
                                    caption: iget2('b-ya-money-payment', 'ostalos-s', 'Осталось, {foo}', {
                                        foo: u.currencies.getName(data.work_currency)
                                    }),
                                    defCol: defaultColumn,
                                    script: data.script
                                },
                                    data.FORM)
                            },
                            {
                                elem: 'cell',
                                mix: [
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'td',
                                        elemMods: {
                                            align: 'right',
                                            column: 'sum'
                                        }
                                    },
                                    {
                                        block: 'b-ya-money-payment',
                                        elem: 'head-cell'
                                    }
                                ],
                                content: iget2('b-ya-money-payment', 'summa-k-oplate-bez', 'Сумма к оплате (без учета НДС), {foo}', {
                                    foo: u.currencies.getName(data.work_currency)
                                })
                            }
                        ]
                    }
                ]
            }
        ];
    }),

    elem('table-body').def()(function() {
        var data = this.data,
            allSum = 0,
            allSumRest = 0,
            c = data.campaigns,
            rows = [],
            sumValue,
            num;

        rows = c.map(function(item, i) {
            num = i + 1;

            allSum = allSum + item.sum;
            allSumRest = allSumRest + item.sum_rest;

            sumValue = data.FORM['oldsum_' + item.cid] || data.FORM['sum_' + item.cid] || '';

            return {
                elem: 'row',
                mix: [{
                    block: 'b-ya-money-payment',
                    elem: 'camp'
                }],
                content: [
                    {
                        elem: 'cell',
                        mix: [{
                            block: 'b-ya-money-payment',
                            elem: 'td'
                        }],
                        content: num + '.'
                    },
                    {
                        elem: 'cell',
                        mix: [{
                            block: 'b-ya-money-payment',
                            elem: 'td'
                        }],
                        content: [
                            {
                                block: 'link',
                                url: u.getUrl('showCamp', {
                                    cid: item.cid,
                                    ulogin: data.FORM.ulogin || data.uid_url.value
                                }),
                                content: item.name
                            },
                            {
                                block: 'b-ya-money-payment',
                                elem: 'campaign-id',
                                content: '(&#8470;&nbsp;' + item.cid + ')'
                            },
                            item.ManagerUID && {
                                block: 'b-ya-money-payment',
                                elem: 'manager-uid',
                                content: '*'
                            }
                        ]
                    },
                    {
                        elem: 'cell',
                        mix: [{
                            block: 'b-ya-money-payment',
                            elem: 'td'
                        }],
                        content: item.status.text
                    },
                    {
                        elem: 'cell',
                        mix: [{
                            block: 'b-ya-money-payment',
                            elem: 'td',
                            elemMods: {
                                align: 'right'
                            }
                        }],
                        content: u.formatPrice(item.sum)
                    },
                    {
                        elem: 'cell',
                        mix: [{
                            block: 'b-ya-money-payment',
                            elem: 'td',
                            elemMods: {
                                align: 'right'
                            }
                        }],
                        content: u.formatPrice(item.sum_rest)
                    },
                    {
                        elem: 'cell',
                        mix: [{
                            block: 'b-ya-money-payment',
                            elem: 'td',
                            elemMods: {
                                align: 'right'
                            }
                        }],
                        content: {
                            block: 'input',
                            mods: {
                                clear: 'no',
                                camp: item.cid,
                                autocomplete: 'off'
                            },
                            mix: [{
                                block: 'b-ya-money-payment',
                                elem: 'input-sum'
                            }],
                            value: sumValue,
                            content: {
                                elem: 'control',
                                attrs: {
                                    maxlength: 10
                                }
                            },
                            attrs: {
                                tabindex: num
                            },
                            name: 'sum_' + item.cid
                        }
                    }
                ]
            };
        });

        rows.push({
            elem: 'row',
            mix: [{
                block: 'b-ya-money-payment',
                elem: 'summary'
            }],
            content: [
                {
                    elem: 'cell',
                    mix: [{
                        block: 'b-ya-money-payment',
                        elem: 'td'
                    }],
                    content: '&nbsp;'
                },
                {
                    elem: 'cell',
                    mix: [
                        {
                            block: 'b-ya-money-payment',
                            elem: 'td'
                        },
                        {
                            block: 'b-ya-money-payment',
                            elem: 'summary-caption'
                        }
                    ],
                    content: iget2('b-ya-money-payment', 'itogo', 'Итого') + ':'
                },
                {
                    elem: 'cell',
                    mix: [{
                        block: 'b-ya-money-payment',
                        elem: 'td'
                    }],
                    content: '&nbsp;'
                },
                {
                    elem: 'cell',
                    mix: [{
                        block: 'b-ya-money-payment',
                        elem: 'td',
                        elemMods: {
                            align: 'right'
                        }
                    }],
                    content: u.formatPrice(allSum)
                },
                {
                    elem: 'cell',
                    mix: [{
                        block: 'b-ya-money-payment',
                        elem: 'td',
                        elemMods: {
                            align: 'right'
                        }
                    }],
                    content: u.formatPrice(allSumRest)
                },
                {
                    elem: 'cell',
                    mix: [{
                        block: 'b-ya-money-payment',
                        elem: 'td',
                        elemMods: {
                            align: 'right',
                            sum: 'cu'
                        }
                    }],
                    content: '0.00'
                }
            ]
        });

        return [{
            elem: 'tbody',
            mix: [{
                block: 'b-ya-money-payment',
                elem: 'tbody'
            }],
            content: rows
        }];
    }),

    elem('table-foot').def()(function() {
        return [{
            elem: 'tfoot',
            mix: [{
                block: 'b-ya-money-payment',
                elem: 'tfoot'
            }],
            content: [
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            content: '&nbsp;'
                        },
                        {
                            elem: 'cell',
                            content: '&nbsp;',
                            attrs: {
                                colspan: 3
                            }
                        },
                        {
                            elem: 'cell',
                            mix: [
                                {
                                    block: 'b-ya-money-payment',
                                    elem: 'td',
                                    elemMods: {
                                        align: 'right'
                                    }
                                },
                                {
                                    block: 'b-ya-money-payment',
                                    elem: 'payment-sum'
                                }
                            ],
                            content: iget2('b-ya-money-payment', 'summa-k-oplate-yandeks', 'Сумма к оплате Яндекс.Деньгами (с учетом НДС)') + ':'
                        },
                        {
                            elem: 'cell',
                            mix: [{
                                block: 'b-ya-money-payment',
                                elem: 'td',
                                elemMods: {
                                    align: 'right',
                                    sum: 'rur'
                                }
                            }],
                            content: iget2('b-ya-money-payment', 's-rub', '{foo} руб.', {
                                foo: '0.00'
                            })
                        }
                    ]
                }
            ]
        }];
    })
);
