(function() {

    var allSumInputBlocks, //коллекция инпутов суммы кампаний
        sum,
        CUR_NAME, //имя текущей валюты
        MIN_PAY, //минимальный платеж кампании в текущей валюте
        RATE,  //курс
        nds,
        numberFormatter = u.numberFormatter;

    BEM.DOM.decl('b-ya-money-payment', {

        onSetMod: {

            js: function() {
                MIN_PAY = u.currencies.getConst(this.params.currency, 'MIN_PAY');
                CUR_NAME = u.currencies.getName(this.params.currency);
                //сейчас у нас есть только рубли и у.е., курс я.денег решено не пробрасывать отдельно
                RATE = this.params.currency == 'YND_FIXED' ? this.params.cuRate : 1;
                nds = this.params.currency == 'YND_FIXED' ? 0 : parseFloat(this.params.nds) / 100;

                allSumInputBlocks = this.findBlocksOn('input-sum', 'input');

                allSumInputBlocks.forEach(function(input) {
                    input.on('change', this.calcSum, this);
                    input.on('blur', this._formatInputOnBlur, this);
                }.bind(this));

                this.bindTo('submit', this._onFormSubmit);
            }
        },

        /**
         * Форматирует значение инпута, callback события blur
         * @param {Object} e
         * @private
         */
        _formatInputOnBlur: function(e) {
            var input = e.block,
                value = input.val().trim();

            if (value === '') {
                input.delMod('error');

                return;
            }

            input.val(this._formatCurrency(value));
        },

        /**
         * Событие submit формы
         * @returns {Boolean} Результат для обработчика (выполнять/не выполнять submit)
         * @private
         */
        _onFormSubmit: function() {
            var camps = [], //список кампаний не прошедших валидацию
                valid = true,
                message = [],
                minError = false, //флаг для отображения уточняющего сообщения
                val;

            //метрика
            try {
                yaCounter191494.reachGoal('PAY-YAMON-PROF');
                yaCounter18641516.reachGoal('PAY-YAMON-PROF');
            } catch (e) { }

            this.findBlocksOn('input-sum', { blockName: 'input', modName: 'error', modVal: 'yes' })
                .forEach(function(block) {
                    val = parseInt(block.val(), 10);

                    valid = false;
                    minError = minError || !isNaN(val) && val < MIN_PAY;
                    camps.push(block.getMod('camp'));
                });

            if (!valid && camps) {
                if (camps.length > 1) {
                    message.push(iget2('b-ya-money-payment', 'nepravilno-ukazana-summa-v', 'Неправильно указана сумма в кампаниях №№ {foo}.', {
                        foo: camps.join(', ')
                    }));

                } else {
                    message.push(iget2('b-ya-money-payment', 'nepravilno-ukazana-summa-v-100', 'Неправильно указана сумма в кампании № {foo}.', {
                        foo: camps[0]
                    }));
                }

                if (minError) {
                    message.push(iget2('b-ya-money-payment', 'summa-oplaty-za-kazhduyu', 'Сумма оплаты за каждую кампанию не должна быть меньше {foo} {bar}', {
                        foo: MIN_PAY,
                        bar: CUR_NAME
                    }));
                }
            }

            if (valid && !sum) {
                message.push(iget2('b-ya-money-payment', 'ne-ukazana-summa-k', 'Не указана сумма к оплате.'));
                valid = false;
            }

            message.length && BEM.blocks['b-confirm'].open({
                message: message,
                type: 'alert',
                onYes: (function() {
                    !valid && camps.length &&
                        this.findBlockOn('input-sum', { blockName: 'input', modName: 'camp', modVal: camps[0] })
                            .setMod('focused', 'yes');
                }).bind(this)
            });

            return valid;
        },

        _formatCurrency: function(val) {
            return numberFormatter.format(val, {
                fail: '',
                precision: 2,
                exponentDelimiter: ' '
            })
        },

        /**
         * Расчет и отображение итоговых сумм
         * @param {Object} e
         */
        calcSum: function(e) {
            var focusedInput = e.block,
                value = focusedInput.val();

            focusedInput.val(value ? numberFormatter.clear(value, { fail: '' }) : '');

            sum = 0;
            allSumInputBlocks.forEach(function(input) {
                var raw = input.val(),
                    value = (+numberFormatter.clear(input.val(), { fail: '' }));

                input.setMod('error', raw && value < MIN_PAY ? 'yes' : '');

                value && (sum += value);
            });

            this.elem('td', 'sum', 'cu').text(this._formatCurrency(sum));
            this.elem('td', 'sum', 'rur').text(this._formatCurrency((sum * RATE * (1 + nds))) + ' ' + iget2('b-ya-money-payment', 'rub', 'руб.'));
        }
    });
})();
