block('b-ya-money-wallet-payment')(

    def()(function() {
        return applyNext({
            isYndFixed: this.data.work_currency == 'YND_FIXED'
        });
    }),

    addJs()(function() {
        return {
            cuRate: this.data.conv_unit_rate,
            currency: this.data.work_currency,
            nds: this.data.work_currency != 'YND_FIXED' ? this.data.client_nds : 0
        };
    }),

    content()(function() {
        var hiddenInputs = {
                yamoney: 1,
                cmd: 'payforall'
            },
            firstCampaign = this.data.campaigns[0];

        !this.isYndFixed && (hiddenInputs.sums_with_nds = 1);

        return {
            block: 'b-layout-form',
            action: this.data.SCRIPT,
            method: 'POST',
            hiddenInputs: [{
                mix: [{
                    block: 'b-ya-money-wallet-payment',
                    elem: 'sum-hidden'
                }],
                name: 'sum_' + firstCampaign.wallet_cid,
                value: ''
            }].concat(Object.keys(hiddenInputs).map(function(name) {
                return {
                    name: name,
                    value: hiddenInputs[name]
                };
            })),
            rows: [{
                block: 'b-ya-money-wallet-payment',
                elem: 'form-content',
                content: [
                    {
                        elem: 'errors'
                    },
                    {
                        block: 'b-layout-table',
                        content: [
                            {
                                elem: 'row',
                                content: [
                                    {
                                        elem: 'cell',
                                        mix: [{
                                            block: 'b-ya-money-wallet-payment',
                                            elem: 'label'
                                        }],
                                        content: iget2('b-ya-money-wallet-payment', 'popolnit-obshchiy-schyot-na', 'Пополнить общий счёт на')
                                    },
                                    {
                                        elem: 'cell',
                                        mix: [{
                                            block: 'b-ya-money-wallet-payment',
                                            elem: 'input-cell'
                                        }],
                                        content: {
                                            block: 'input',
                                            mods: {
                                                clear: 'no',
                                                autocomplete: 'off'
                                            },
                                            mix: [{
                                                block: 'b-ya-money-wallet-payment',
                                                elem: 'input-sum'
                                            }],
                                            value: '',
                                            content: {
                                                elem: 'control',
                                                attrs: {
                                                    maxlength: 10
                                                }
                                            }
                                        }
                                    },
                                    {
                                        elem: 'cell',
                                        content: u.currencies.getName(this.data.work_currency)
                                    },
                                    {
                                        elem: 'cell',
                                        mix: [{
                                            block: 'b-ya-money-wallet-payment',
                                            elem: 'note'
                                        }],
                                        content: this.isYndFixed ?
                                            iget2('b-ya-money-wallet-payment', 'primechanie-1-u-e', 'Примечание: 1 у.е. = {foo} руб.', {
                                                foo: this.data.conv_unit_rate
                                            }) : ''
                                    }
                                ]
                            },
                            !this.isYndFixed && {
                                elem: 'row',
                                content: [
                                    {
                                        elem: 'cell',
                                        mix: [{
                                            block: 'b-ya-money-wallet-payment',
                                            elem: 'label'
                                        }],
                                        content: iget2('b-ya-money-wallet-payment', 'nds', 'НДС')
                                    },
                                    {
                                        elem: 'cell',
                                        mix: [
                                            {
                                                block: 'b-ya-money-wallet-payment',
                                                elem: 'money-label'
                                            },
                                            {
                                                block: 'b-ya-money-wallet-payment',
                                                elem: 'nds'
                                            }
                                        ],
                                        content: ''
                                    },
                                    {
                                        elem: 'cell',
                                        content: u.currencies.getName(this.data.work_currency)
                                    },
                                    {
                                        elem: 'cell',
                                        content: ''
                                    }
                                ]
                            },
                            {
                                elem: 'row',
                                mix: [{
                                    block: 'b-ya-money-wallet-payment',
                                    elem: 'rub-sum'
                                }],
                                content: [
                                    {
                                        elem: 'cell',
                                        mix: [{
                                            block: 'b-ya-money-wallet-payment',
                                            elem: 'label'
                                        }],
                                        content: iget2('b-ya-money-wallet-payment', 'summa-k-oplate-yandeks-101', 'Сумма к оплате Яндекс.Деньгами') + ':'
                                    },
                                    {
                                        elem: 'cell',
                                        mix: [
                                            {
                                                block: 'b-ya-money-wallet-payment',
                                                elem: 'money-label'
                                            },
                                            {
                                                block: 'b-ya-money-wallet-payment',
                                                elem: 'sum-rub'
                                            }
                                        ],
                                        content: '0.00'
                                    },
                                    {
                                        elem: 'cell',
                                        content: iget2('b-ya-money-wallet-payment', 'rub', 'руб.')
                                    },
                                    {
                                        elem: 'cell',
                                        content: ''
                                    }
                                ]
                            },
                            {
                                elem: 'row',
                                content: [
                                    {
                                        elem: 'cell',
                                        attrs: {
                                            colspan: 4
                                        },
                                        content: [
                                            {
                                                block: 'b-ya-money-wallet-payment',
                                                elem: 'separator'
                                            },
                                            {
                                                block: 'b-ya-money-wallet-payment',
                                                elem: 'note',
                                                content: iget2('b-ya-money-wallet-payment', 'minimalnyy-platezh-s', 'Минимальный платеж: {foo}', {
                                                    foo: u.currencies.formatConst(this.data.work_currency, 'MIN_PAY')
                                                })
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]

            }],
            submit: {
                block: 'b-ya-money-wallet-payment',
                elem: 'submit-wrap',
                content: {
                    block: 'button',
                    mix: [{
                        block: 'b-ya-money-wallet-payment',
                        elem: 'submit-button'
                    }],
                    type: 'submit',
                    content: iget2('b-ya-money-wallet-payment', 'oplatit', 'Оплатить')
                }
            }
        };
    }),

    elem('errors').content()(function() {
        return this.data.FORM.error_code ? this.data.pay_error_text : '';
    })
);
