(function() {

    var CUR_NAME, //имя текущей валюты
        MIN_PAY, //минимальный платеж кампании в текущей валюте
        RATE, //курс
        numberFormatter = u.numberFormatter;

    BEM.DOM.decl('b-ya-money-wallet-payment', {
        onSetMod: {

            js: function() {
                MIN_PAY = u.currencies.getConst(this.params.currency, 'MIN_PAY');
                CUR_NAME = u.currencies.getName(this.params.currency);
                //сейчас у нас есть только рубли и у.е., курс я.денег решено не пробрасывать отдельно
                RATE = this.params.currency == 'YND_FIXED' ? this.params.cuRate : 1;

                this.sumInputBlock = this.findBlockOn('input-sum', 'input')
                    .on('blur', this._formatValue, this)
                    .on('change', this._calcSum, this);

                this.nds = this.params.nds / 100;

                this.bindTo('submit', this._validateForm);

                this._calcSum({ onInit: true });
            }

        },

        /**
         * Форматирует значение инпута
         * @private
         */
        _formatValue: function() {
            var sum = numberFormatter.clear(this.sumInputBlock.val());

            this.sumInputBlock.val(
                isNaN(sum) ?
                    '0.00' :
                    numberFormatter.format(sum, { precision: 2 }));
        },

        /**
         * Валидирует форм, в случае ошибки показывает ее
         * @returns {Boolean} Результат для обработчика (выполнять/не выполнять submit)
         * @private
         */
        _validateForm: function() {
            var isValid = true,
                sum = numberFormatter.clear(this.sumInputBlock.val());

            if (sum && !isNaN(sum) && sum < MIN_PAY) {
                isValid = false;
                this.elem('errors').text(iget2('b-ya-money-wallet-payment', 'summa-oplaty-ne-dolzhna', 'Сумма оплаты не должна быть меньше {foo} {bar}', {
                    foo: MIN_PAY,
                    bar: CUR_NAME
                }));
            }

            if (!sum) {
                isValid = false;
                this.elem('errors').text(iget2('b-ya-money-wallet-payment', 'ne-ukazana-summa-k', 'Не указана сумма к оплате.'))
            }

            !isValid && this.sumInputBlock.setMod('focused', 'yes');

            return isValid;
        },

        /**
         * Рассчитывает и отображает итоговые суммы
         * @private
         */
        _calcSum: function(e) {
            !e.onInit && this.elem('errors').text('');

            var sum = +numberFormatter.clear(this.sumInputBlock.val()),
                nds = sum * this.nds,
                sumRub = isNaN(sum + nds) ? '0.00' : numberFormatter.format((sum + nds) * RATE, { precision: 2 });

            this.elem('nds') &&
                this.elem('nds').text(isNaN(nds) ? '0.00' : numberFormatter.format(nds, { precision: 2 }));
            //если валюта рубли (RATE == 1) то сумму на платеж выставляем с НДС, если нет - то нет НДС и счет в оригинальной валюте
            this.elem('sum-hidden').val(RATE == 1 ? sumRub : sum);
            this.elem('sum-rub').text(sumRub);
        }

    });
})();
