(function() {
    var version = '20';
    var firstTeaserType = '1_2';
    var secondTeaserType = '2';

    block('b-ya-surveys-teaser')(
        def()(null),

        match(function() {
            return u.consts('tld') === 'ru' && this.data.cmd === 'showCamp';
        }).def()(function() {
            var teaserType1Available =
                    this.data.features_enabled_for_operator &&
                    this.data.features_enabled_for_operator.show_ya_surveys_custom_teaser_type_1 === 1 &&
                    this.data.COOKIES[u['b-ya-surveys-teaser'].getCookieName(version, firstTeaserType)] !== '1',
                teaserType2Available =
                    this.data.features_enabled_for_operator &&
                    this.data.features_enabled_for_operator.show_ya_surveys_custom_teaser_type_2 === 1 &&
                    this.data.COOKIES[u['b-ya-surveys-teaser'].getCookieName(version, secondTeaserType)] !== '1',
                headers = [
                    iget2('b-ya-surveys-teaser', 'header1_2', 'Знают ли о вашем бизнесе в округе?'),
                    iget2('b-ya-surveys-teaser', 'header2', 'Насколько ваша реклама заметна?')
                ],
                texts = [
                    iget2('b-ya-surveys-teaser', 'text1_2', 'Сравните свой бизнес с конкурентами с помощью Яндекс.Взгляда'),
                    iget2('b-ya-surveys-teaser', 'text2', 'Спросите людей об этом с помощью Яндекс.Взгляда')
                ],
                mods = ['ya-survey-1', 'ya-survey-2'],
                urls = [
                    'https://surveys.yandex.ru/fastgeo/new-landing?utm_medium=tizer&utm_source=custom_tizer_direct&utm_campaign=direct-89784&utm_content=fastgeo',
                    'https://surveys.yandex.ru/?utm_source=custom_tizer_direct&utm_medium=tizer&utm_campaign=direct-89784&utm_content=mainservice'
                ],
                header,
                text,
                mod,
                idx,
                url;

            if (teaserType1Available && teaserType2Available) {
                idx = Math.round(Math.random());
            } else if (teaserType1Available) {
                idx = 0;
            } else if (teaserType2Available) {
                idx = 1;
            } else {
                return null;
            }

            header = headers[idx];
            text = texts[idx];
            mod = mods[idx];
            url = urls[idx];

            return {
                block: 'b-ya-surveys-teaser',
                mix: this.ctx.mix,
                mods: {
                    type: mod
                },
                js: {
                    version: version,
                    type: idx === 0 ? firstTeaserType : secondTeaserType
                },
                content: [
                    {
                        block: 'link',
                        mix: [
                            { block: 'b-ya-surveys-teaser', elem: 'link' }
                        ],
                        mods: {
                            theme: 'none'
                        },
                        target: '_blank',
                        url: url,
                        content: [
                            {
                                block: 'b-ya-surveys-teaser',
                                elem: 'header',
                                content: header
                            },
                            {
                                block: 'b-ya-surveys-teaser',
                                elem: 'text',
                                content: text
                            }
                        ]
                    },
                    {
                        block: 'button2',
                        mix: [
                            { block: 'b-ya-surveys-teaser', elem: 'close-btn' }
                        ],
                        mods: {
                            size: 'n',
                            theme: 'clear'
                        },
                        icon: {
                            mods: {
                                glyph: 'type-close',
                                'glyph-color': 'white',
                                'glyph-size': 'n'
                            }
                        }
                    }
                ]
            };
        })
    );
})();
