BEM.DOM.decl('b-ya-surveys-teaser', {
    onSetMod: {
        js: function() {
            this._closeBtn = this.findBlockOn('close-btn', 'button2');
            this._metrika = BEM.blocks['b-metrika2'];

            this._cookie = u['b-ya-surveys-teaser'].getCookieName(this.params.version, this.params.type);

            this._closeBtn.on('click', this._onClose, this);

            this._metrika.reachGoal({
                target: 'custom_tizer_show',
                params: {
                    custom_tizer_show: '1',
                    custom_tizer_type: this.params.type
                }
            });
        }
    },

    destruct: function() {
        this._closeBtn.un('click', this._onClose, this);
        this.__self.liveUnbindFrom('link', 'click');
        this.__base.apply(this, arguments);
    },

    _onClose: function() {
        $.cookie(this._cookie, '1', { expires: 10000 });

        this._metrika.params({ params: { custom_tizer_closed: '1' } });
        this._metrika.reachGoal({
            target: 'custom_tizer_closed',
            callback: this.destruct.bind(this)
        });
    },

    _onLinkClick: function() {
        this._metrika.reachGoal('custom_tizer_click');
        this._metrika.params({ params: { custom_tizer_click: '1' } });
    }
}, {
    live: function() {
        this.liveBindTo('link', 'click', function() {
            this._onLinkClick();
        });
        return false;
    }
});
