block('brand-lift-control').elem('content')(

    content()(function() {
        return {
            block: 'button2',
            mods: { theme: 'normal', size: 's' },
            mix: { block: 'brand-lift-control', elem: 'edit' },
            text: iget2(
                'brand-lift-control',
                'create-brandlift',
                'Заказать исследование'
            )
        };
    }),

    match(function() {
        return this.ctx.id;
    })(
        content()(function() {
            return {
                block: 'spin',
                mods: { theme: 'gray-16', progress: 'yes' }
            };
        }),

        match(function() {
            return this.ctx.state;
        }).content()(function() {
            var ctx = this.ctx,
                surveyStatus = u._.get(ctx.state, 'brand_survey_status_web.survey_status_daily'),
                isCompleted = surveyStatus === 'completed',
                isActive = surveyStatus === 'active',
                isDraft = surveyStatus === 'draft',
                isModerationRejected = surveyStatus === 'moderation_rejected';

            return [
                {
                    elem: 'status',
                    state: ctx.state,
                    currency: ctx.currency,
                    reasons: ctx.reasons,
                    dayBudgetThreshold: ctx.dayBudgetThreshold,
                    totalBudgetThreshold: ctx.totalBudgetThreshold
                },
                {
                    block: 'button2',
                    mods: { theme: 'normal', size: 's' },
                    mix: { block: 'brand-lift-control', elem: 'edit' },
                    text: isDraft || isModerationRejected ?
                        iget2('brand-lift-control', 'edit-brandlift-params', 'Редактировать') :
                        iget2('brand-lift-control', 'show-brandlift-params', 'Посмотреть опрос')
                },
                isDraft && {
                    block: 'button2',
                    mods: { theme: 'normal', size: 's' },
                    mix: { block: 'brand-lift-control', elem: 'stop-survey' },
                    text: iget2(
                        'brand-lift-control',
                        'stop-survey',
                        'Отменить исследование'
                    )
                },
                (isCompleted || isActive) ? {
                    block: 'button2',
                    mods: { theme: 'normal', size: 's' },
                    mix: { block: 'brand-lift-control', elem: 'show-stats' },
                    text: iget2(
                        'brand-lift-control',
                        'result-stats-brandlift',
                        'Результаты исследования'
                    )
                } : ''
            ];
        })
    )
);
