block('brand-lift-control').elem('status')(

    match(function() {
        return !(
            this.ctx.state &&
            this.ctx.state.brand_survey_status_web
        );
    }).def()(''),

    content()(function() {
        var state = this.ctx.state,
            status = state.brand_survey_status_web.survey_status_daily,
            statusReasons = state.brand_survey_status_web.brand_survey_stop_reasons_daily || [],
            sumSpentByDay = state.brand_survey_status_web.sum_spent_by_day,
            sumSpentByTotalPeriod = state.brand_survey_status_web.sum_spent_by_total_period,
            statusTexts = {
                draft: iget2('brand-lift-control', 'status-draft', 'Черновик'),
                moderation: iget2('brand-lift-control', 'status-moderation', 'На модерации'),
                moderation_rejected: iget2('brand-lift-control', 'status-moderation-rejected2', 'Опрос приостановлен'),
                active: iget2('brand-lift-control', 'status-active', 'Сбор данных.'),
                completed: iget2('brand-lift-control', 'status-closed', 'Опрос завершён'),
                unfeasible: iget2('brand-lift-control', 'status-unfeasible', 'Остановлено'),
                calculation: iget2('brand-lift-control', 'status-calculation', 'Проверка условий'),
            },
            detailedText;

        if (status === 'unfeasible') {
            detailedText = apply('unfeasibleDetail', {
                'ctx.statusReasons': statusReasons,
                'ctx.currency': this.ctx.currency,
                'ctx.sumSpentByDay': sumSpentByDay,
                'ctx.sumSpentByTotalPeriod': sumSpentByTotalPeriod,
                'ctx.dayBudgetThreshold': this.ctx.dayBudgetThreshold,
                'ctx.totalBudgetThreshold': this.ctx.totalBudgetThreshold
            });
        } else if (status === 'completed') {
            detailedText = iget2(
                'brand-lift-control',
                'result-text',
                'Доступны результаты.'
            );
        } else if (status === 'draft' || status === 'moderation') {
            detailedText = iget2(
                'brand-lift-control',
                'data-moderation-text',
                'Сбор данных начнётся после того как исследование пройдёт модерацию.'
            );
        } else if (status === 'active') {
            detailedText = iget2(
                'brand-lift-control',
                'data-active-text',
                'Доступны промежуточные результаты, они могут отличаться от финальных результатов.'
            );
        } else if (status === 'moderation_rejected') {
            detailedText = this.ctx.reasons.map(function(reasonText) {
                return {
                    elem: 'list-item',
                    content: reasonText
                };
            });
        } else if (status === 'calculation') {
            detailedText = iget2(
                'brand-lift-control',
                'data-calculation-text',
                'Рассчитываются бюджет, охват и продолжительность кампании, необходимые для проведения Brand Lift. Это может занять некоторое время.'
            )
        }

        return [
            {
                elem: 'status-text',
                elemMods: {
                    status: u.beminize(status)
                },
                content: statusTexts[status]
            },
            detailedText ? {
                elem: 'reason-text',
                content: detailedText
            } : ''
        ];
    }),

    mode('unfeasibleDetail')(function() {
        var statusReasons = this.ctx.statusReasons,
            currency = this.ctx.currency,
            sumSpentByDay = this.ctx.sumSpentByDay,
            sumSpentByTotalPeriod = this.ctx.sumSpentByTotalPeriod,
            budgetThreshold = this.ctx.dayBudgetThreshold,
            totalBudgetThreshold = this.ctx.totalBudgetThreshold,
            minDaysCampaignBrandLiftInterval = 14,
            formatNumber = function(num) {
                return u.numberFormatter.format(num, { precision: 0 });
            },
            currencySymbol = u.currencies.get(currency).currency_sign,
            statusReasonsTexts = statusReasons.map(function(reason) {
                switch (reason) {
                    case 'low_daily_budget':
                    case 'low_budget':
                        return sumSpentByDay ?
                            iget2(
                                'brand-lift-control',
                                'stop-budget-daily',
                                'Бюджет вашей кампании — {sumSpentByDay} {currencySymbol} в день, необходимо не менее {budgetThreshold} {currencySymbol} в день',
                                {
                                    currencySymbol: currencySymbol,
                                    budgetThreshold: formatNumber(budgetThreshold),
                                    sumSpentByDay: formatNumber(sumSpentByDay)
                                }
                            ) :
                            iget2(
                                'brand-lift-control',
                                'stop-budget-zero-daily',
                                'Вчера ваша кампания была неактивна'
                            );
                    case 'low_total_budget':
                        return sumSpentByTotalPeriod ?
                            iget2(
                                'brand-lift-control',
                                'low-total-budget',
                                'Прогноз расхода по кампании — {sumSpentByTotalPeriod} {currencySymbol}, необходимо не менее {brandSurveyBudgetThreshold} {currencySymbol} за весь период работы кампании',
                                {
                                    currencySymbol: currencySymbol,
                                    brandSurveyBudgetThreshold: formatNumber(totalBudgetThreshold),
                                    sumSpentByTotalPeriod: formatNumber(sumSpentByTotalPeriod),
                                }
                            ) : '';

                    case 'low_reach':
                        return iget2(
                            'brand-lift-control',
                            'stop-coverage-daily',
                            'Прогнозируемый охват кампании должен быть от 2 млн'
                        );
                    case 'short_period':
                        return iget2(
                            'brand-lift-control',
                            'stop-period-daily',
                            'Кампания должна работать не менее {minDaysCampaignBrandLiftInterval} дней',
                            { minDaysCampaignBrandLiftInterval: minDaysCampaignBrandLiftInterval }
                        );
                }
            });

        return statusReasonsTexts.map(function(reasonText) {
            return {
                block: 'brand-lift-control',
                elem: 'list-item',
                content: reasonText
            };
        }).concat({
            block: 'link',
            attrs: { target: '_blank' },
            url: u.getCommonHelpUrl('direct/brand-lift.html'),
            mix: { block: 'brand-lift-control', elem: 'list-item' },
            content: iget2('brand-lift-control', 'more-info-link', 'Подробнее')
        })
    })

);
