BEM.DOM.decl('brand-lift-control', {
    _modalOpened: false,

    onSetMod: {
        js: function() {
            this._campaignModel = BEM.MODEL.getOrCreate(this.params.modelParams);

            this._initialize();
        }
    },

    _initialize: function() {
        this._binding();

        return this._updateStatus({ id: this.params.brandSurveyId });
    },

    _binding: function() {
        this._onCloseForm = this._onCloseForm.bind(this);
        this._onSurveySave = this._onSurveySave.bind(this);
        this._deleteSurvey = this._deleteSurvey.bind(this);
        this._onSurveyError = this._onSurveyError.bind(this);
        this._onSurveyDelete = this._onSurveyDelete.bind(this);
        this._onRequestRejectReasons = this._onRequestRejectReasons.bind(this);
    },

    _updateStatus: function() {
        var cid = this._campaignModel.get('cid'),
            surveyId = this._campaignModel.get('brand_survey_id'),
            isSurveyIdChanged = this._campaignModel.isChanged('brand_survey_id');

        if (cid && surveyId && !isSurveyIdChanged) {
            // Статус опроса получаем по cid, если кампания еще не создана ИЛИ id-опроса еще не сохранен в кампании -
            // то запрос делать незачем
            return this._requestStatus(cid)
                .then(function(state) {
                    this._campaignModel.set(
                        'brand_survey_state',
                        u._.get(state, 'brand_survey_status_web.survey_status_daily', '')
                    );

                    return Promise.all([this._requestRejectReasons(state), this._requestBrandSurveyConditions()])
                        .catch(Promise.resolve)
                        .then(function(responses) {
                            return this._updateAndRender({ id: surveyId, state: state, reasons: responses[0] });
                        }.bind(this));
                }.bind(this))
                .catch(function() {
                    this.campaignModel.set('brand_survey_state', '');
                    return this._updateAndRender({ id: surveyId, state: undefined, reasons: undefined });
                }.bind(this));
        } else if (!surveyId) {
            // Нет опроса - нет вопроса =)
            return this._updateAndRender({ id: undefined, state: undefined, reasons: undefined });
        } else {
            // В осталных случаях (нет cid ИЛИ id опроса есть, но он изменен) это черновик
            return this._updateAndRender({ id: surveyId, state: { brand_survey_status_web: { survey_status: 'draft' } } });
        }
    },

    _onButtonClick: function(e, data) {
        var domElem = e.block.domElem;

        if (this.findElem('stop-survey').is(domElem)) {
            BEM.blocks['b-user-dialog'].confirm({
                message: iget2(
                    'brand-lift-control',
                    'cancel-survey',
                    'Вы действительно хотите отменить исследование Brand Lift?'
                ),
                onConfirm: function() {
                    this._deleteSurvey();
                }.bind(this)
            });
        }

        if (this.findElem('edit').is(domElem)) {
            this._openForm();
        }

        if (this.findElem('show-stats').is(domElem)) {
            this._openForm({ showStats: true });
        }
    },

    _openForm: function(options) {
        this._modalOpened = true;
        this._getFakePopup().trigger('show');
        this._renderDnaComponent(options);
    },

    _mapToUpperCase: u._.memoize(function(array) {
        if (!array) {
            return [];
        }

        return array.map(function(e) {
            return e.toUpperCase();
        });
    }),

    _mapToString: u._.memoize(function(array) {
        if (!array) {
            return [];
        }

        return array.map(String);
    }),

    _mapBrandSurveyStatus: u._.memoize(function(brandSurveyStatus) {
        return {
            surveyStatus: brandSurveyStatus.survey_status_daily.toUpperCase(),
            reasonIds: this._mapToString(brandSurveyStatus.reason_ids),
            sumSpentByDay: Number(brandSurveyStatus.sum_spent_by_day),
            sumSpentByTotalPeriod: Number(brandSurveyStatus.sum_spent_by_total_period),
            brandSurveyStopReasons: this._mapToUpperCase(brandSurveyStatus.brand_survey_stop_reasons_daily)
        }
    }),

    _renderDnaComponent: function(options) {
        var dna = window.dna;
        options = options || {};

        if (!this._options.state) {
            return;
        }

        dna.reactDOMRender(dna.reactCreateElement(
            dna.components.BrandLiftIFrameWrapper, {
                isVisible: this._modalOpened,
                clientId: this.params.clientId,
                // Для меньшего кол-ва перерисовок, мемоизируем массив который попадает на вход
                brandSurveyStatus: this._mapBrandSurveyStatus(this._options.state.brand_survey_status_web),
                brandSurveyId: this._options.id,
                surveysUiUrl: u.consts('surveysUiUrl'),
                rejectReasonsText: this._options.reasons,
                currency: this.params.currency,
                budgetThreshold: this._dayBudgetThreshold,
                totalBudgetThreshold: this._totalBudgetThreshold,
                minDaysCampaignBrandLiftInterval: 14,
                campaignId: this._campaignModel.get('cid'),
                isOpenModalOnSurveyResults: options.showStats,
                onClose: this._onCloseForm,
                getRejectReasonText: this._onRequestRejectReasons,
                onStopSurvey: this._deleteSurvey,
                onSurveySaveError: this._onSurveyError,
                onSurveySaveSuccess: this._onSurveySave,
                tld: u.consts('tld'),
            }, null), this.elem('modal')[0]);
    },

    _onCloseForm: function() {
        this._modalOpened = false;
        this._getFakePopup().trigger('hide');
        this._renderDnaComponent();
    },

    _onSurveyError: function() {
        BEM.blocks['b-confirm'].open({
            type: 'alert',
            message: iget2(
                'brand-lift-control',
                'fail-message',
                'При сохранении опроса произошла ошибка. Попробуйте ещё раз.'
            )
        });

        this._onCloseForm();
    },

    _onSurveySave: function(brandSurveyId) {
        this._campaignModel.set('brand_survey_id', brandSurveyId);

        this._onCloseForm();
        this._updateStatus();
    },

    _onSurveyDelete: function() {
        this._campaignModel.set('brand_survey_id', undefined);

        this._onCloseForm();
        this._updateStatus();

        this.trigger('delete');
    },

    _updateAndRender: function(options) {
        this._options = u._.assign({}, this._options, options);

        return new Promise(function(resolve) {
            BEM.DOM.update(
                this.domElem,
                BEMHTML.apply([
                    {
                        block: this.__self.getName(),
                        elem: 'content',
                        currency: this.params.currency,
                        id: this._options.id,
                        state: this._options.state,
                        reasons: this._options.reasons,
                        dayBudgetThreshold: this._dayBudgetThreshold,
                        totalBudgetThreshold: this._totalBudgetThreshold
                    },
                    {
                        block: this.__self.getName(),
                        elem: 'modal'
                    }
                ]),
                resolve,
                this
            );
        }.bind(this))
            .then(function(result) {
                this._renderDnaComponent();
                return result;
            }.bind(this));
    },

    _requestStatus: function(cid) {
        return BEM.blocks['i-web-api-request'].brandLift.getBrandLift(
            u.consts('ulogin'),
            cid
        ).then(function(response) {
            return response.result[0];
        });
    },

    _deleteSurvey: function() {
        var cid = this._campaignModel.get('cid');

        (cid ? BEM.blocks['i-web-api-request'].brandLift.deleteBrandLift(
            u.consts('ulogin'),
            cid
        ) : Promise.resolve())
            .then(this._onSurveyDelete)
            .catch(function() {
                BEM.blocks['b-confirm'].alert(iget2(
                    'brand-lift-control',
                    'cancel-survey-fail-message',
                    'Не удалось отменить исследование'
                ));
            });
    },

    _onRequestRejectReasons: function(brandSurveyState) {
        return this._requestRejectReasons(brandSurveyState)
            .then(function(reasons) {
                return this._updateAndRender({ reasons: reasons });
            });
    },

    _requestRejectReasons: function(brandSurveyState) {
        var reasonIds = brandSurveyState.brand_survey_status_web.reason_ids;

        return BEM.blocks['i-web-api-request'].moderationReason.getModerationDeclineReasonsContent(reasonIds)
            .then(function(response) {
                var reasons = response.reasons,
                    reasonsText = Object.keys(reasons).map(function(reasonId) {
                        var parsedReason = JSON.parse(reasons[reasonId]);

                        return parsedReason.selector['.title'].match(/<h1.*?>(.*?)<\/h1>/)[1];
                    });

                return reasonsText;
            });
    },

    _requestBrandSurveyConditions: function() {
        var dna = window.dna,
            ulogin = u.consts('ulogin'),
            cid = this._campaignModel.get('cid');

        if (!dna) {
            throw new Error('An error has occurred in loading DNA dependencies');
        }

        var queryExecutor = dna.utils.getQueryExecutor(ulogin);

        return queryExecutor.multipleCampaignsBrandSurveyConditions({ campaignIds: [cid] })
            .then(function(conditions) {
                var brandSurveyConditions = conditions.data.multipleCampaignsBrandSurveyConditions;
                this._dayBudgetThreshold = brandSurveyConditions.dayBudgetThreshold;
                this._totalBudgetThreshold = brandSurveyConditions.totalBudgetThreshold;

                return;
            }.bind(this));
    },

    _getFakePopup: function() {
        // Попап нужен для того чтобы при открытии реактовского попапа на странице скрывался ползунок скролла,
        // c помощью инициализации `popup_body-scroll_no` (без помещения его в DOM) и триггера на экземпляре блока
        // событий `show` и `hide`, отрабатывает логика из data3/desktop.blocks/popup/_body-scroll/popup_body-scroll_no.js
        // про показ/скрывание скрола всей страницы. В реактовском коде эта логика не реализована
        return this._fakePopup ||
            (this._fakePopup = $(BEMHTML.apply({ block: 'popup', mods: { 'body-scroll': 'no' } })).bem('popup'));
    },

    destruct: function() {
        window.dna.reactDOMUnmount(this.elem('modal')[0]);
        this._getFakePopup().trigger('hide').destruct();
        BEM.DOM.destruct(this.domElem, true); // чистим внутренности

        return this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button2', function(e, data) {
            this._onButtonClick(e, data);
        });

        return false;
    }

});
