block('brand-lift-form')(

    js()(function() {
        return u._.pick(this.ctx.options, [''])
    }),

    content()(function() {
        var options = this.ctx.options,
            id = options.id,
            surveyStatus = u._.get(options.state, 'brand_survey_status_web.survey_status'),
            readOnly = options.id ? !(['draft', 'moderation_rejected'].includes(surveyStatus)) : false,
            showStats = options.showStats,
            sharedData = encodeURIComponent(
                JSON.stringify({ // ignore stringify
                    clientId: options.clientId,
                    lang: u.consts('lang') === 'ua' ? 'uk' : u.consts('lang')
                })
            ),
            src = u.formatUrl({
                host: u.consts('surveysUiUrl'),
                path: id ? ('/brandlift/survey/' + id) : '/brandlift',
                query: { shared_data: sharedData }
            }),
            statsSrc = u.formatUrl({
                host: u.consts('surveysUiUrl'),
                path: '/brandlift/statistics/' + id,
                query: { shared_data: sharedData }
            }),
            width = 700,
            height = 500;

        return [
            {
                elem: 'body',
                mix: { block: 'b-modal-popup-decorator', elem: 'body' },
                content: [
                    {
                        elem: 'fake-content',
                        attrs: {
                            style: 'width: ' + width + 'px; height: ' + height + 'px;'
                        }
                    },
                    {
                        elem: 'frame-wrapper',
                        content: {
                            block: 'i-foreign-iframe',
                            mix: { block: this.block, elem: 'iframe' },
                            attrs: {
                                src: showStats ? statsSrc : src,
                                width: '100%',
                                height: '100%'
                            }
                        }
                    }
                ]
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' },
                content: [
                    (readOnly || showStats) ?
                        '' :
                        {
                            block: 'button',
                            mods: { theme: 'action' },
                            mix: { block: this.block, elem: 'save' },
                            content: iget2('brand-lift-form', 'save', 'Сохранить')
                        },
                    {
                        block: 'button',
                        mix: { block: this.block, elem: 'cancel' },
                        content: iget2('brand-lift-form', 'cancel', 'Отмена')
                    }
                ]
            }
        ];
    })

);
