BEM.DOM.decl({ block: 'brand-lift-form', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {
        js: function() {
            this._iframe = this.findBlockOn('iframe', 'i-foreign-iframe');
        }
    },

    isChanged: function() {
        var deferred = $.Deferred();

        this._request('hasChanges')
            .then(function(response) {
                deferred.resolve(response.hasChanges);
            })
            .catch(function() {
                deferred.resolve(true);
            });

        return deferred.promise();
    },

    _request: function(action) {
        var iframe = this._iframe;

        return new Promise(function(resolve, reject) {
            var subMan = BEM.create('i-subscription-manager'),
                reqId = setTimeout(function() {
                    subMan.dispose();
                    subMan.destruct();

                    reject();
                }, 10 * 1000);

            subMan.on(iframe, 'message', function(e, iframeMessage) {
                var data = JSON.parse(iframeMessage.data);

                subMan.dispose();
                subMan.destruct();

                clearTimeout(data.reqId);

                switch (data.status) {
                    case 'ok':
                        return resolve(data.result || u._.pick(data, 'hasChanges'));
                    case 'validation-error':
                        return reject(u._.pick(data, 'status'));
                    default:
                        return reject();
                }
            }, this);

            iframe.postMessage({ type: action, reqId: reqId }, '*');
        });
    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        var domElem = e.block.domElem;

        if (this.elem('save').is(domElem)) {
            this._onSaveClick(e, data);
        } else if (this.elem('cancel').is(domElem)) {
            this._onCancelClick(e, data);
        }
    },

    _onSaveClick: function() {
        this._request('save')
            .then(function(data) {
                this.trigger('save', data)
            }.bind(this))
            .catch(function(params) {
                if (!params || params.status !== 'validation-error') {
                    this.trigger('fail');
                }
            }.bind(this))
    },

    _onCancelClick: function() {
        this.trigger('cancel');
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
            this._onButtonClick(e, data);
        });
    }

});
