block('clients-selector')(

    def()(function() {
        return applyNext({
            names: this.ctx.clients.reduce(function(result, item) {
                return u._.set(result, item.client_id, item.login);
            }, {})
        });
    }),

    js()(function() {
        return {
            names: this.names,
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            clients = ctx.clients || [],
            selectedIds = ctx.selectedIds || [],
            names = this.names,
            selectedNames = selectedIds.map(function(id) {
                return u.escapeHTML(names[id] || '');
            }).join(', ') || '—',
            clientsList = clients.map(
                function(item) {
                    var name = u.escapeHTML(item.login),
                        id = item.client_id,
                        isSelected = selectedIds.indexOf(id) !== -1;

                    return {
                        elem: 'item',
                        elemMods: isSelected ? { selected: 'yes' } : undefined,
                        name: id,
                        content: name,
                        js: { text: name, id: id }
                    };
                }
            ),
            isWithSearch = clients.length > 5;

        return [
            {
                block: 'button2',
                mods: { theme: 'normal', size: 's', width: 'max' },
                iconRight: {
                    mods: { type: 'arrow', direction: 'bottom' }
                },
                mix: { block: 'clients-selector', elem: 'button' },
                text: selectedNames
            },
            {
                block: 'popup2',
                mods: { target: 'anchor', theme: 'normal', autoclosable: 'yes' },
                directions: ['bottom-left', 'top-left'],
                mix: { block: 'clients-selector', elem: 'popup' },
                content: {
                    block: 'clients-selector',
                    elem: 'popup-content',
                    content: [
                        {
                            block: 'clients-selector',
                            elem: 'title',
                            content: {
                                block: 'check-button',
                                mix: { block: 'clients-selector', elem: 'check-all' },
                                mods: { size: 'xs', pseudo: 'yes', theme: 'normal' },
                                content: iget2('clients-selector', 'check-all', 'Выбрать всех')
                            }
                        },
                        {
                            block: 'b-chooser',
                            mods: { multi: 'yes', theme: 'checkboxes', search: isWithSearch ? 'yes' : '' },
                            mix: { block: 'clients-selector', elem: 'chooser' },
                            content: [
                                isWithSearch && {
                                    elem: 'search',
                                    mix: { block: 'clients-selector', elem: 'search' },
                                },
                                {
                                    elem: 'wrap',
                                    content: clientsList
                                },
                                isWithSearch && {
                                    elem: 'not-found',
                                    mix: { block: 'clients-selector', elem: 'not-found' },
                                }
                            ]
                        }
                    ]
                }
            }
        ];
    })
);
