BEM.DOM.decl('clients-selector', {

    onSetMod: {

        js: function() {
            this._popup = this.findBlockOn('popup', 'popup2');
            this._button = this.findBlockOn('button', 'button2');
            this._chooser = this.findBlockOn('chooser', 'b-chooser');
            this._checkButton = this.findBlockInside('check-all', 'check-button');

            this._popup.setAnchor(this._button);

            this._subMan = BEM.create('i-subscription-manager');

            if (this._checkButton) {
                this._subMan.on(this._checkButton, 'click', this._onCheckButtonClick, this);
            }

            this._subMan.on(this._popup, 'beforeOpen beforeClose', this._onPopupOpenClose, this);
            this._subMan.on(this._chooser, 'change', this._onChoose, this);
        },

    },

    getVal: function() {
        return u._.map(this._chooser.getSelected(), 'name');
    },

    /**
     * Обработчик клика по кнопке
     * @private
     */
    _onButtonClick: function() {
        this._popup.toggleMod('visible', 'yes');
    },

    /**
     * Крутит стрелку вокгруг своей оси
     * @private
     */
    _rotateArrow: function() {
        this._button.blockInside('icon').toggleMod('direction', 'top', 'bottom');
    },

    /**
     * Обработчик событий открытия и закрытия попапа
     * @param {jQuery.Event} e
     * @private
     */
    _onPopupOpenClose: function(e) {
        if (e.type === 'beforeOpen') {
            this._setMaxHeight();
        }

        this._rotateArrow();
    },

    /**
     * Обработчик изменений в блоке
     * @private
     */
    _onChange: function() {
        var value = this.getVal();

        this._updateButtonText(value);

        this.trigger('change', { value: value });
    },

    /**
     * Обработчик выбора в `b-chooser`
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {string} data.name
     * @param {boolean} data.selected
     * @private
     */
    _onChoose: function(e, data) {
        if (!data.silent) {
            this._onChange();
        }
    },

    _updateButtonText: function(value) {
        var names = this.params.names;

        this._button.setText(
            value.map(function(id) { return u.escapeHTML(names[id] || '') }).join(', ') || '—'
        );
    },

    _onCheckButtonClick: function(e, data) {
        var chooser = this._chooser,
            isChecked = e.block.isChecked();

        if (isChecked) {
            u._.map(u._.filter(chooser.getAll(), { selected: false }), 'name')
                .forEach(function(name) {
                    chooser.check(name, { silent: true })
                });
        } else {
            chooser.uncheckAll();
        }

        this._onChange();
    },

    /**
     * Устанавливает попапу максимальную высоту.
     *
     * @protected
     */
    _setMaxHeight: function() {
        var drawingParams = this._popup.calcPossibleDrawingParams(),
            contentElem = this.findElem(this._popup.domElem, 'popup-content'),
            contentElemWidth = contentElem.outerWidth(),
            bestHeight = 0;

        drawingParams.forEach(function(params) {
            params.width >= contentElemWidth && params.height > bestHeight && (bestHeight = params.height);
        });

        if (bestHeight) {
            contentElem.css('max-height', bestHeight);

            this._popup.redraw();
        }
    },

    /**
     * Сбрасывает все подписки
     * @private
     */
    _dropSubMan: function() {
        if (this._subMan) {
            this._subMan.dispose();
            this._subMan.destruct();
            this._subMan = null;
        }
    },

    destruct: function() {
        this._dropSubMan();

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button2', function(e) {
                this._onButtonClick(e);
            });
    }

});
