block('composite')(

    def()(function() {
        return applyNext({
            _compositeId: this.ctx.id || u._.uniqueId('c-'),
            _compositeIdAttr: this.ctx.idAttr,
            _compositeCollection: this.ctx.collection,
            _compositeItemView: this.ctx.itemView,
            _compositeLayout: this.ctx.layout || { block: 'composite', elem: 'items' }
        });
    }),

    js()(function() {
        return {
            id: this._compositeId,
            itemView: this._compositeItemView,
            idAttr: this._compositeIdAttr
        };
    }),

    content()(function() {
        return this._compositeLayout;
    }),

    elem('items')(

        mix()(function() {
            return {
                block: 'composite',
                elem: 'items',
                elemMods: { pid: this._compositeId }
            };
        }),

        content()(function() {
            return (this._compositeCollection || []).map(function(data) {
                return u.composite.getItemBemJson(
                    this._compositeId,
                    this._compositeItemView,
                    this._compositeIdAttr,
                    data);
            }, this);
        })
    )
);
