u.register({
    composite: {
        /**
         * Расширяет контекст дополнительными данными
         * @param {Object} inputCtx - исходный контекст
         * @param {Object} data - объект расширения
         * @returns {Object}
         * @private
         */
        modifyCtx: function(inputCtx, data) {
            var ctx = u._.extend({}, inputCtx);

            data || (data = {});

            ctx.mix = [].concat(ctx.mix || [], data.mix || []);

            u._.forOwn(u._.omit(data, 'mix'), function(value, key) {

                if (u._.isArray(ctx[key])) {
                    ctx[key].push(u.composite.toArray(value));
                } else if (u._.isObject(ctx[key]) && u._.isObject(value)) {
                    ctx[key] = u._.extend({}, ctx[key], value);
                } else {
                    ctx[key] = value;
                }
            });

            return ctx;
        },

        /**
         * Подгатавливает и форматирует данные для шаблонизации элемента списка
         * @param {Object} data - данные для элемента списка
         * @param {String} idAttr - поле-идентификатор
         */
        prepareItemData: function(data, idAttr) {
            data.id = data[idAttr] || data.id || u._.uniqueId('composite-item');
        },

        /**
         * Формирует BEMJSON элемента списка
         * @param {String} id - идентификатор списка
         * @param {Object} itemView - представление элемента
         * @param {String} idAttr - имя ключа-идентификатора
         * @param {Object} data - данные для элемента
         * @returns {Object}
         */
        getItemBemJson: function(id, itemView, idAttr, data) {
            u.composite.prepareItemData(data, idAttr);

            return u.composite.modifyCtx(itemView, {
                itemData: data,
                compositeId: id,
                mix: {
                    block: 'composite',
                    elem: 'item',
                    elemMods: {
                        pid: id,
                        'item-id': u.composite.getItemModVal(id, data.id)
                    }
                }
            });
        },

        /**
         * Формирует значение модификатора item-id для элемента
         * @param {String} compositeId - идентификатор списка
         * @param {String} id - идентификатор элемента
         * @returns {String}
         */
        getItemModVal: function(compositeId, id) {
            return [compositeId, id].join('-');
        },

        /**
         * Преобразует в массив входные данные
         * @param {*} input - входные данные
         * @returns {Array}
         * @private
         */
        toArray: function(input) {
            return input ? !u._.isArray(input) ? [input] : input : [];
        }
    }
});
