BEM.DOM.decl('cpm-yndx-frontpage-min-price', {}, {

    _storage: {},

    /**
     * Получаем минимальные ставки для всех групп и/или кампании
     * @param {String} cid
     * @param {Object[]} groups
     * @param {String} groups.geo
     * @param {Number} groups.price
     * @param {String} groups.adgroup_id
     * @param {String} groups.adgroup_id
     * @param {Boolean} [isAutobudget]
     * @param {Number} [price]
     * @return {Promise}
     */
    initGroupsMinPrice: function(cid, groups, isAutobudget, price) {
        var deferred = $.Deferred();

        if (!(groups || []).length) {
            deferred.resolve();
        }

        BEM.blocks['i-web-api-request'].cpmYndxFrontpage.getFrontpagePriceWarnings(
            u.consts('ulogin'),
            this._getRequestParams(cid, groups, false, isAutobudget, price)
        ).then(function(javaResp) {
            var javaGroupsData = javaResp.response_items || [];

            u._.set(this._storage, [cid, 'minPrice'], javaResp.min_price);

            javaGroupsData.forEach(function(group) {
                u._.set(this._storage, [cid, group.adgroup_id, 'minPrice'], group.adgroup_min_price);

                u._.set(
                    this._storage,
                    [cid, group.adgroup_id, 'errors'],
                    u._.get(group, ['validation_result', 'errors'])
                );

                u._.set(
                    this._storage,
                    [cid, group.adgroup_id, 'warnings'],
                    u._.get(group, ['validation_result', 'warnings'])
                );

                this.channel('cpm-yndx-frontpage-min-price').trigger('group-' + group.adgroup_id + '-inited');
            }, this);

            deferred.resolve();
            this.channel('cpm-yndx-frontpage-min-price').trigger('groups-inited');
        }.bind(this)).catch(function() {
            deferred.reject();
            throw new Error();
        });

        return deferred.promise();
    },

    /**
     * Получаем минимальные ставки для всех кампании
     * @param {String[]} cids - id кампаний
     */
    initCampsMinPrices: function(cids) {
        var requests = [];

        if (cids.length) {
            cids.forEach(function(cid) {
                requests.push(this._campRequest(cid));
            }, this);
        }

        Promise.all(requests).then(function() {
            this.channel('cpm-yndx-frontpage-min-price').trigger('camps-inited');
        }.bind(this)).catch(function() {
            throw new Error('initCampsMinPrices error');
        });
    },

    /**
     * Возращает минимальную ставку по заданному пути
     * или же берет константную ставку (если по заданному пути нет данных)
     * @param {Array} path - путь, [cid] или [cid, adgroup_id]
     * @param {String} currencyName - валюта
     * @returns {Number}
     */
    getMinPrice: function(path, currencyName) {
        return u._.get(
            this._storage,
            path.concat('minPrice'),
            u.currencies.getConst(currencyName, 'MIN_CPM_FRONTPAGE_PRICE')
        );
    },

    /**
     * Возвращает результат валидации ставки на группе (ошибки и предупреждения)
     * @param {Array} path - путь, [cid, adgroup_id]
     * @return {*|void}
     */
    getGroupValidationResults: function(path) {
        return u._.pick(
            u._.get(this._storage, path),
            ['errors', 'warnings']
        );
    },

    /**
     * Получаем минимальную ставку для кампании
     * @param {String} cid - id кампании
     * @returns {Promise}
     * @private
     */
    _campRequest: function(cid) {
        var deferred = $.Deferred();

        BEM.blocks['i-web-api-request'].cpmYndxFrontpage.getFrontpagePriceWarnings(
            u.consts('ulogin'),
            this._getRequestParams(cid, [], true)
        ).then(function(javaResp) {
            deferred.resolve();

            u._.set(this._storage, [cid, 'minPrice'], javaResp.min_price);
        }.bind(this)).catch(function() {
            deferred.reject();
            throw new Error();
        });

        return deferred.promise();
    },

    /**
     *
     * @param {String} cid
     * @param {Array} groups
     * @param {Boolean} [getAdgroupsData]
     * @param {Boolean} [isAutobudget]
     * @param {Number} [price]
     * @return {Object}
     * @private
     */
    _getRequestParams: function(cid, groups, getAdgroupsData, isAutobudget, price) {
        var params = {
            campaign_geo: '',
            campaign_id: cid,
            validate_campaign: false,
            get_adgroups_data: Boolean(getAdgroupsData),
            frontpage_warnings_get_items: groups
        };

        if (isAutobudget) {
            params.strategy_auto_price = price;
        }

        return params;
    }

});
