BEM.DOM.decl({ block: 'creative-preview-opener' }, {

    /**
     * Показывает попап
     * @private
     */
    _showPopup: function() {
        // что бы закрытие модального попапа с увеличенной картинкой не закрывало родительский попап
        var outsidePopup = this.findBlockOutside('popup');

        if (outsidePopup) {
            this._getPopup()
                .findBlockOn('popup')
                .setParent(outsidePopup);
        }

        this._getPopup().on('hide', this._onPopupHide, this);

        this
            ._getPopup()
            .setContent(BEMHTML.apply(this.params.popupContent))
            .show();
    },

    /**
     * Обработчик
     * @private
     */
    _onPopupHide: function() {
        // в креативе может быть звук, который будет проигрываться после закрытия попапа
        this._getPopup().setContent({});
    },

    /**
     * Возвращает блок попап для показа оригинала изображения
     * @returns {BEM}
     */
    _getPopup: function() {
        return this._popup ||
            (this._popup = BEM.blocks['b-shared-popup']
                .getInstance({
                    type: 'modal',
                    position: 'fixed',
                    'has-close': 'yes'
                },
                {},
                {
                    content: {
                        block: 'creative-preview-opener',
                        elem: 'popup-content'
                    }
                },
                {
                    type: 'paranja'
                })
            );
    },

    destruct: function() {
        this._getPopup().un('hide', this._onPopupHide);
        this.__base.apply(this, arguments);
    }

}, {

    live: function() {

        this.liveBindTo('image-wrapper', 'pointerclick', function(e) {
            e.preventDefault();
            this._showPopup();
        });

    }

});
