BEM.DOM.decl({ block: 'creative-preview' }, {

    onSetMod: {
        js: function() {
            this._renderDnaVideoPreview();
        }
    },

    _renderDnaVideoPreview: function() {
        var dna = window.dna,
            html5Block, clickUrl;

        clickUrl = u._.get(this.params, 'postData.data.click_url.clickUrl1');
        html5Block = this.findBlockInside('dna-html5-preview');
        if (clickUrl) {
            html5Block.bindTo('click', function() {
                window.open(clickUrl, '_blank');
            });
        }

        var preview = dna.reactCreateElement(
            dna.components.Html5CreativePreview,
            {
                previewUrl: this.params.url,
                cspNonce: BEM.blocks['i-global'].param('nonce'),
                width: this.params.width,
                height: this.params.height,
                parentNode: { current: html5Block.domElem[0] }
            },
            null
        );

        dna.reactDOMRender(
            preview,
            html5Block.domElem[0]
        )
    }
});
