block('crypta-advisor')(
    js()(function() {
        return {
            data: this.ctx.data,
            profilesDisabled: this.ctx.profilesDisabled
        };
    }),

    content()(function() {

        return {
            block: 'b-expander',
            mods: {
                size: 's'
            },
            title: {
                block: this.block,
                elem: 'title',
                content: iget2('crypta-advisor', 'header-text', 'Увеличить охват')
            },
            body: {
                block: this.block,
                elem: 'advise',
                content: [
                    {
                        elem: 'loader'
                    },
                    {
                        elem: 'advise-result'
                    }
                ]
            }
        };
    }),

    elem('recommendation').content()(function() {
        var result = this.ctx.result,
            banners = (result.banner_formats || [])
                .filter(function(banner) {
                    return banner.increase_percent > 1 || banner.increase_percent === null;
                })
                .sort(function(a, b) { return b.increase_percent - a.increase_percent; })
                .slice(0, 3),
            profilesDisabled = this.ctx.profilesDisabled;

        return {
            elem: 'proposal',
            content: banners.length === 0 ?
                {
                    elem: 'proposal-title',
                    mix: {
                        block: this.block,
                        elem: 'proposal-empty'
                    },
                    content: profilesDisabled ?
                        iget2(
                            'crypta-advisor',
                            'proposal-empty-no-profiles',
                            'Расширьте географию показов'
                        ) :
                        iget2(
                            'crypta-advisor',
                            'proposal-empty',
                            'Поменяйте настройки в профиле пользователей - отключите условия на часть характеристик или поменяйте на более широкие группы пользователей.'
                        )
                } :
                [
                    {
                        elem: 'proposal-title',
                        content: iget2('crypta-advisor', 'banner-title', 'Добавьте баннеры')
                    },
                    {
                        elem: 'proposal-container',
                        content: banners.map(function(banner) {
                            return {
                                elem: 'banner',
                                content: [
                                    {
                                        elem: 'banner-format',
                                        content: banner.format
                                    },
                                    banner.increase_percent && {
                                        elem: 'increase-percent',
                                        content: iget2('crypta-advisor', 'increase-precent', '+{number}%', {
                                            number: u.numberFormatter.roundFormatted(banner.increase_percent, {
                                                precision: 1,
                                                fail: 0,
                                                floatDelimiter: ','
                                            })
                                        })
                                    }
                                ]
                            };
                        })
                    }
                ]
        };
    }),

    elem('recommendation-error').content()(function() {

        return {
            elem: 'proposal',
            content: {
                elem: 'proposal-title',
                content: iget2('crypta-advisor', 'proposal-error', 'Прогноз временно недоступен')
            }
        };
    }),

    elem('loader').content()(function() {

        return {
            block: 'spin2',
            mix: {
                block: this.block,
                elem: 'spin'
            },
            mods: { size: 's', progress: 'yes' }
        };
    })
);
