BEM.DOM.decl({ block: 'crypta-advisor' }, {

    onSetMod: {

        js: function() {
            this._data = this.params.data;
        },

        open: {
            yes: function() {
                this.blockInside('b-expander').setMod('open', 'yes');

                this.setMod(this.elem('advise'), 'loading', 'yes');

                this._getRecommendation();
            },
            '': function() {
                this.elem('advise').height('');
                this.blockInside('b-expander').delMod('open');
            }
        }

    },

    /**
     * Обновляет данные по которым будет строится прогноз
     * @param {ReachParams} data
     */
    updateData: function(data) {
        this._data = data;
    },

    /**
     * Обработчик раскрытия блока
     * @private
     */
    _onExpanderOpen: function() {
        this.setMod('open', 'yes');
    },

    /**
     * Обработчик закрытия блока
     * @private
     */
    _onExpanderClose: function() {
        this.delMod('open');
    },

    /**
     * Получение рекомендации
     * @private
     */
    _getRecommendation: function() {
        return BEM.blocks['i-web-api-request'].mediareach
            .getReachRecommendation(u.consts('ulogin'), this._data)
            .then(this.onRecommendationSuccess.bind(this))
            .catch(this.onRecommendationError.bind(this));
    },

    /**
     * Обработки удачного запроса рекомендации
     * @param {Object} response
     * @param {Object} response.result - результат рекомендации
     */
    onRecommendationSuccess: function(response) {
        if (!this.hasMod('open', 'yes')) {
            return;   // если блок свернули результат не обрабатываем
        }

        // рисуем результат
        BEM.DOM.update(this.elem('advise-result'), BEMHTML.apply({
            block: 'crypta-advisor',
            elem: 'recommendation',
            profilesDisabled: this.params.profilesDisabled,
            result: response.result
        }));

        // плавно подстраиваем высоту контейнера
        this._updateContainerHeight(
            this.findElem('recommendation').height(),
            this._hideLoader.bind(this)
        );

        this.trigger('success');
    },

    /**
     * Обработчик неудачного запроса рекомендации
     */
    onRecommendationError: function() {
        if (!this.hasMod('open', 'yes')) {
            return;  // если блок свернули результат не обрабатываем
        }

        // рисуем ошибку под лоадером (скрытно)
        BEM.DOM.update(this.elem('advise-result'), BEMHTML.apply({
            block: 'crypta-advisor',
            elem: 'recommendation-error'
        }));

        // плавно подстраиваем высоту контейнера
        this._updateContainerHeight(
            this.findElem('recommendation-error').height(),
            this._hideLoader.bind(this)
        );

        this.trigger('error');
    },

    /**
     * Изменяет высоту контейнера результата
     * @param {Number} height - выставляемая высота
     * @param {Function} complete - колбек по завершению
     * @private
     */
    _updateContainerHeight: function(height, complete) {
        this.elem('advise').animate({
            height: height + 'px'
        }, {
            step: function() {
                BEM.DOM.win.trigger('resize'); // TODO костыль из-за нехватки времени, исправит @grimfrid
            },
            complete: complete
        });
    },

    /**
     * Прячет loader
     * @private
     */
    _hideLoader: function() {
        this.delMod(this.elem('advise'), 'loading');
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('open', 'b-expander', function() {
            this._onExpanderOpen();
        });

        this.liveInitOnBlockInsideEvent('close', 'b-expander', function() {
            this._onExpanderClose();
        });

    }

});
