BEM.DOM.decl({ block: 'crypta-summary-provider' }, {

    onSetMod: {

        js: function() {

            this._data = this.params.data;

            this._loadSegmentAndGoals()
                .then(function() {
                    this._renderSummary();
                    this.trigger('ready');
                }.bind(this));
        }

    },

    /**
     * Обновляет содержимое
     * @param {PredictParams} data
     */
    update: function(data) {
        this._data = data;
        if (!this.hasMod('loading', 'yes')) {
            this._renderSummary();
        }
    },

    /**
     * Загружает список сегментов и целей доступных пользователю
     * @returns {Promise}
     * @private
     */
    _loadSegmentAndGoals: function() {
        this.setMod('loading' , 'yes');

        return Promise.all([
            BEM.blocks['i-crypta-segments-data'].getSegmentsHash(),
            BEM.blocks['i-retargeting-goals-data'].getGoalsHash()
        ])
            .then(function(responses) {

                this._segmentsHash = responses[0];
                this._goalsHash = responses[1];

                this.delMod('loading');
            }.bind(this))
            .catch(function(e) {
                this.delMod('loading');
                this.setMod('error' , 'yes');
            }.bind(this));

    },

    /**
     * Отображение сводки
     */
    _renderSummary: function() {
        BEM.DOM.update(this.elem('container'), BEMHTML.apply({
            block: 'crypta-summary',
            data: this._data,
            segments: this._segmentsHash,
            goals: this._goalsHash
        }));
    }

});
