block('crypta-summary')(

    content()(function() {
        var ctx = this.ctx,
            summary = u['crypta-summary'].calculateSummary(ctx.data, ctx.segments, ctx.goals);
        return {
            elem: 'text',
            summary: summary
        };
    }),

    elem('text')(

        content()(function() {
            var order = ['banner', 'geo', 'social_demo', 'family', 'interests', 'metrika', 'audio_genres', 'regions', 'formats', 'operators', 'platforms', 'categories', 'zones'],
                summary = (this.ctx.summary || []).sort(function(a, b) {
                    return order.indexOf(a.type) - order.indexOf(b.type);
                }),
                outdoorTypes = ['regions', 'formats', 'operators', 'platforms'],
                indoorTypes = ['regions', 'categories', 'zones', 'screens'];

            return summary.map(function(data) {
                return {
                    elem: 'item',
                    elemMods: {
                        type: data.type,
                        outdoor: outdoorTypes.includes(data.type),
                        indoor: indoorTypes.includes(data.type)
                    },
                    data: data
                };
            });
        })
    ),

    elem('item')(

        content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    content: data.parents.join(' > ')
                },
                {
                    elem: 'group-goals',
                    content: data.items.join(', ')
                },
                { tag: 'br' }
            ];
        }),

        elemMod('type', 'metrika').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    content: data.parents[0] + ' (' + data.rule + ')'
                },
                {
                    elem: 'group-goals',
                    content: data.items && data.items.map(function(item, index) {
                        var content = (index + 1) + '. ' + u.escapeHTML(item.text);

                        if (item.time) {
                            content += ' (' + iget2('crypta-summary', 'summary-days', 'за {time} день', {
                                time: item.time,
                                count: item.time,
                                some: 'за {time} дня',
                                many: 'за {time} дней',
                                context: 'Аудитория (за 22 дня)'
                            }) + ')';
                        }

                        return {
                            elem: 'group-metrika-goal',
                            elemMods: u._.extend({}, item.mods),
                            content: content
                        };
                    })
                },
                { tag: 'br' }
            ]
        }),

        elemMod('type', 'interests').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    content: data.parents.join(' > ') + ' (' + data.period + ')'
                },
                {
                    elem: 'group-goals',
                    content: data.items.join(', ')
                },
                { tag: 'br' }
            ];
        }),

        elemMod('type', 'banner').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    content: iget2('crypta-summary', 'banner-sizes-name', 'Размеры баннеров')
                },
                {
                    elem: 'group-goals',
                    content: u._.uniq(data.sizes.map(function(item) {
                        var size;

                        if (item.isAdaptive) {
                            return iget2('crypta-summary', 'adaptive', 'Адаптивный баннер');
                        }

                        if (item.ration) {
                            size = item.ration.replace('/', ':');
                        } else {
                            size = item.width + 'x' + item.height;
                        }

                        return size;
                    })).join(', ')
                },
                { tag: 'br' }
            ];
        }),

        elemMod('type', 'geo').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    content: iget2('crypta-summary', 'group-geo', 'Регионы')
                },
                {
                    elem: 'group-goals',
                    content: data.text
                },
                { tag: 'br' }
            ];
        }),

        elemMod('type', 'formats').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    tag: 'span',
                    elemMods: { outdoor: true },
                    content: iget2('crypta-summary', 'formats', 'Форматы') + ':'
                },
                {
                    elem: 'group-goals',
                    tag: 'span',
                    elemMods: { outdoor: true },
                    content: data.text
                }
            ];
        }),

        elemMod('type', 'regions').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    tag: 'span',
                    elemMods: { outdoor: true },
                    content: iget2('crypta-summary', 'group-geo', 'Регионы') + ':'
                },
                {
                    elem: 'group-goals',
                    tag: 'span',
                    elemMods: { outdoor: true, indoor: true },
                    content: data.text
                }
            ];
        }),

        elemMod('type', 'operators').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    tag: 'span',
                    elemMods: { outdoor: true },
                    content: iget2('crypta-summary', 'operators', 'Операторы') + ':'
                },
                {
                    elem: 'group-goals',
                    tag: 'span',
                    elemMods: { outdoor: true },
                    content: data.text
                }
            ];
        }),

        elemMod('type', 'platforms').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    tag: 'span',
                    elemMods: { outdoor: true },
                    content: iget2('crypta-summary', 'screens', 'Экраны') + ':'
                },
                {
                    elem: 'group-goals',
                    tag: 'span',
                    elemMods: { outdoor: true, indoor: true },
                    content: data.count
                }
            ];
        }),

        elemMod('type', 'zones').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    tag: 'span',
                    elemMods: { indoor: true },
                    content: iget2('crypta-summary', 'zones', 'Зоны') + ':'
                },
                {
                    elem: 'group-goals',
                    tag: 'span',
                    elemMods: { indoor: true },
                    content: data.text
                }
            ];
        }),

        elemMod('type', 'categories').content()(function() {
            var data = this.ctx.data;

            return [
                {
                    elem: 'group-parents',
                    tag: 'span',
                    elemMods: { indoor: true },
                    content: iget2('crypta-summary', 'categories', 'Категории') + ':'
                },
                {
                    elem: 'group-goals',
                    tag: 'span',
                    elemMods: { indoor: true },
                    content: data.text
                }
            ];
        })
    )

);
