BEM.DOM.decl({ block: 'deals-selector-popup', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {
        loading: function(modName, modVal) {
            this.elem('body').scrollTop(0);

            this.blockInside('save', 'button').setMod(
                'disabled',
                modVal ?
                    'yes' :
                    this._isChanged ?
                        '' :
                        'yes'
            );
        }
    },

    /**
     * Инициализирует блок
     * @param {object} params
     * @param {{ deal_id: string, name: string }[]} params.value Привязанные сделки
     * {string} params.cid Номер кампании
     * {string} params.agencyLogin Логин агентства
     * @return {BEM.DOM}
     */
    initialize: function(params) {
        this.setMod('loading', 'yes');

        this._params = params;

        this._dealIds = {
            prev: params.value.reduce(function(res, deal) {
                return u._.set(res, deal.deal_id, true);
            }, {}),
            added: {},
            removed: {}
        };

        var value = params.value,
            valueIds = u._.map(value, 'deal_id'),
            agencyLogin = params.agencyLogin,
            namesById = this._namesById = {};

        BEM.blocks['i-web-api-request'].privateDeals.getDealsList(agencyLogin, null, null, true)
            .then(function(response) {
                if (!response.success) {
                    throw response;
                }

                this.blockInside('deals-selector').drawList(
                    u._.get(response, 'result', [])
                        .filter(function(deal) {
                            return deal.status === 'ACTIVE';
                        })
                        .map(function(deal) {
                            var dealId = deal.id.toString(),
                                dealName = deal.name;

                            namesById[dealId] = dealName;

                            return {
                                id: dealId,
                                name: dealName,
                                addition: dealId
                            };
                        }),
                    valueIds
                );

                this.delMod('loading');

                this.blockInside('deals-selector').focusSearch();
            }.bind(this))
            .catch(function() {
                this.blockInside('b-errors-presenter2').showErrors([
                    {
                        path: '',
                        description: iget2(
                            'deals-selector-popup',
                            'cant-load-list',
                            'Не удалось получить список сделок. Пожалуйста, повторите позже'
                        )
                    }
                ]);

                this.delMod('loading');
            }.bind(this));

        return this;
    },

    /**
     * Возвращает флаг о наличии изменения
     * @return {$.Deferred<boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(this._isChanged);

        return deferred;
    },

    /**
     * Обработчик клика по кнопкам
     * @param {jQuery.Event} e
     * @param {object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('save').is(e.block.domElem) && this._onSaveClick();
        this.elem('cancel').is(e.block.domElem) && this._onCancelClick(e, data);
    },

    /**
     * Сохраняет изменения
     * @private
     */
    _onSaveClick: function() {
        this.setMod('loading', 'yes');
        this.blockInside('b-errors-presenter2').clearErrors();

        var params = this._params,
            cid = params.cid,
            namesById = this._namesById,
            getDealId = function(item) { return item.deal_id.toString() },
            mapper = function(dealId) {
                return { campaign_id: cid, deal_id: dealId };
            },
            removedIds = [],
            addedIds = [],
            errors = [],
            requestParams = {
                remove_links: Object.keys(this._dealIds.removed).map(mapper),
                add_links: Object.keys(this._dealIds.added).map(mapper)
            };

        this._updateDealsRequest(requestParams)
            .then(function(response) {
                addedIds = u._.get(response, 'result.add_links', []).map(getDealId);
                removedIds = u._.get(response, 'result.remove_links', []).map(getDealId);
                errors = errors.concat(u._.get(response, 'validation_result.errors'));
            })
            .then(function() {
                var hasErrors = !!errors.length,
                    value = u._.difference(Object.keys(this._dealIds.prev), removedIds).concat(addedIds);

                if (hasErrors) {
                    var handledErrors = this._handleErrors(errors, requestParams),
                        mapper = u['deals-selector-popup'].getErrorsMapper();

                    this.blockInside('deals-selector').setChoice(value);

                    this._dealIds = {
                        prev: value.reduce(function(res, dealId) {
                            return u._.set(res, dealId, true);
                        }, {}),
                        added: {},
                        removed: {}
                    };

                    this._checkChanges();

                    this.blockInside('b-errors-presenter2').showErrors(
                        handledErrors.map(function(error) {
                            return { path: error.path, description: mapper(requestParams, error) };
                        })
                    );
                }

                this.trigger('save', {
                    value: value.map(function(id) {
                        return { deal_id: id, name: namesById[id] }
                    }),
                    hasErrors: hasErrors
                });

                this.delMod('loading');
            }.bind(this));
    },

    /**
     * Объединяет однотипные ошибки в одну, добавляю в `params.dealIds` идентифакторы сделок для которых ошибка актуальна
     * @param {{ code: string, path: string, description: [string] }[]} errors
     * @param {{ remove_links: {campaign_id: number, deal_id:number}[], add_links: {campaign_id: number, deal_id:number}[] }} requestParams
     * @returns {{ code: string, path: string, description: [string] }[]}
     * @private
     */
    _handleErrors: function(errors, requestParams) {
        return u._.reduce(
            u._.groupBy(
                errors.map(function(error) {
                    return u._.assign(
                        { pathArray: u['b-errors-presenter2'].toPath(error.path) },
                        error
                    )
                }),
                function(err) {
                    return err.pathArray[0] + ':' + err.code;
                }
            ),
            function(result, groupErrors) {
                var firstPartPath = u._.get(groupErrors, '[0].pathArray[0]');

                return result.concat({
                    path: u._.get(groupErrors, '[0].path'),
                    code: u._.get(groupErrors, '[0].code'),
                    params: u._.assign(
                        u._.includes(['add_links', 'remove_links'], firstPartPath) ?
                            {
                                dealIds: groupErrors.map(function(error) {
                                    var pathArray = error.pathArray,
                                        pathToDealId = u['b-errors-presenter2'].joinPath([
                                            firstPartPath,
                                            pathArray[1] || '',
                                            'deal_id'
                                        ]);

                                    return u._.get(requestParams, pathToDealId);
                                })
                            } :
                            {},
                        u._.get(groupErrors, '[0].params')
                    )
                });
            },
            []
        );
    },

    /**
     * Отправляет запрос на сохранение изменений списка сделок
     * @param {{ remove_links: {campaign_id: number, deal_id:number}[], add_links: {campaign_id: number, deal_id:number}[] }} requestParams
     * @private
     */
    _updateDealsRequest: function(requestParams) {
        return BEM.blocks['i-web-api-request'].privateDeals.updateDeals(
                this._params.agencyLogin,
                requestParams
            )
            .then(function(response) {
                // DIRECT-77860: warnings в нашем случае должны восприниматься как ошибка, детали в задаче
                var warnings = u._.get(response, 'validation_result.warnings') || [];

                if (warnings.length) {
                    u._.set(
                        response,
                        'validation_result.errors',
                        (u._.get(response, 'validation_result.errors') || []).concat(warnings));
                }

                return response;
            })
            .then(function(response) {
                if (!response.success) {
                    throw response;
                }

                return response;
            })
            .catch(function(response) {
                if (!u._.get(response, 'validation_result.errors[0]')) {
                    u._.set(response, 'validation_result.errors[0].path', '');
                }

                return response;
            });
    },

    /**
     * Обработчик изменений блока `deals-selector`
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {string[]} data.value
     * @private
     */
    _onChange: function(e, data) {
        var dealId = data.itemId;

        if (data.isSelected) {
            if (this._dealIds.removed[dealId]) {
                this._dealIds.removed = u._.omit(this._dealIds.removed, dealId);
            } else {
                this._dealIds.added[dealId] = true;
            }
        } else {
            if (this._dealIds.added[dealId]) {
                this._dealIds.added = u._.omit(this._dealIds.added, dealId);
            } else {
                this._dealIds.removed[dealId] = true;
            }
        }

        this._checkChanges();
    },

    _checkChanges: function() {
        this._isChanged = !!(Object.keys(this._dealIds.added).length || Object.keys(this._dealIds.removed).length);

        this.blockInside('save', 'button').setMod('disabled', this._isChanged ? '' : 'yes');
    },

    /**
     * Обработчки отмены изменений
     * @private
     */
    _onCancelClick: function() {
        this.trigger('cancel');
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
                this._onButtonClick(e, data);
            })
            .liveInitOnBlockInsideEvent('choose', 'deals-selector', function(e, data) {
                this._onChange(e, data);
            });
    }

});
