(function() {
    var errorsMapper,
        statusErrorsMapper;

    u.register({
        'deals-selector-popup': {

            getErrorsMapper: function() {
                return errorsMapper || (errorsMapper = u['deals-selector-popup'].createErrorsMapper());
            },

            createErrorsMapper: function() {
                return u['web-api-errors'].makeErrorMapper(
                    function(opts) {
                        var idx = opts.idx;

                        return [
                            {
                                path: ['add_links', idx, 'campaign_id'],
                                codes: [
                                    {
                                        code: 'DefectIds.OBJECT_NOT_FOUND',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deals-to-not-found-campaign2',
                                                    'Не удалось привязать сделки {dealIds}. Кампания не&nbsp;найдена.',
                                                    { dealIds: dealIds.join(', ') }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deal-to-not-found-campaign2',
                                                    'Не удалось привязать сделку {dealId}. Кампания не&nbsp;найдена.',
                                                    { dealId: dealIds[0] }
                                                );
                                        }
                                    },
                                    {
                                        code: 'CampaignDefectIds.Gen.CAMPAIGN_TYPE_NOT_SUPPORTED',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deals-to-not-supported-campaign2',
                                                    'Не удалось привязать сделки {dealIds}. Сделки можно привязать только к&nbsp;кампании типа «Медийная кампания со&nbsp;сделками».',
                                                    { dealIds: dealIds.join(', ') }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deal-to-not-supported-campaign2',
                                                    'Не удалось привязать сделку {dealId}. Сделку можно привязать только к&nbsp;кампании типа «Медийная кампания со&nbsp;сделками».',
                                                    { dealId: dealIds[0] }
                                                );
                                        }
                                    },
                                    {
                                        code: 'CampaignDefectIds.Gen.ARCHIVED_CAMPAIGN_MODIFICATION',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deals-to-archived-campaign2',
                                                    'Не удалось привязать сделки {dealIds}. Кампания находится в&nbsp;архиве.',
                                                    { dealIds: dealIds.join(', ') }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deal-to-archived-campaign2',
                                                    'Не удалось привязать сделку {dealId}. Кампания находится в&nbsp;архиве.',
                                                    { dealId: dealIds[0] }
                                                );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['add_links', idx, 'deal_id'],
                                codes: [
                                    {
                                        code: 'DealDefectIds.DEAL_IS_NOT_ACTIVE',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'added-deals-is-not-active2',
                                                    'Не удалось привязать сделки {dealIds}. Сделки должны быть со&nbsp;статусом «Принята».',
                                                    { dealIds: dealIds.join(', ') }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'added-deal-is-not-active2',
                                                    'Не удалось привязать сделку {dealId}. Сделка должна быть со&nbsp;статусом «Принята».',
                                                    { dealId: dealIds[0] }
                                                );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['add_links', idx],
                                codes: [
                                    {
                                        code: 'CampaingDealsDefectIds.MAX_NUMBER_OF_LINKED_DEALS_EXCEEDED',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deals-to-campaign-with-max-number-of-linked-deals2',
                                                    'Не удалось привязать сделки {dealIds}. К&nbsp;кампании уже привязана сделка {currentDealId}. Обновите страницу.',
                                                    {
                                                        dealIds: dealIds.join(', '),
                                                        currentDealId: u._.get(err, 'params.linkedToDealIds[0]')
                                                    }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deal-to-campaign-with-max-number-of-linked-deals2',
                                                    'Не удалось привязать сделку {dealId}. К&nbsp;кампании уже привязана сделка {currentDealId}. Обновите страницу.',
                                                    {
                                                        dealId: u._.get(err, 'params.dealIds[0]'),
                                                        currentDealId: u._.get(err, 'params.linkedToDealIds[0]')
                                                    }
                                                );
                                        }
                                    },
                                    {
                                        code: 'DealDefectIds.Currency.CAMPAIGN_AND_DEAL_CURRENCY_SHOULD_MATCH',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deals-to-campaign-with-not-support-currency2',
                                                    'Не удалось привязать сделки {dealIds}. Кампания в&nbsp;валюте «{currency}». Сделку можно привязать только к кампании в&nbsp;рублях.',
                                                    {
                                                        dealIds: dealIds.join(', '),
                                                        currency: u.currencies.getName(
                                                            err.params.currencyCode, { full: true }
                                                        )
                                                    }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'add-deal-to-campaign-with-not-support-currency2',
                                                    'Не удалось привязать сделку {dealId}. Кампания в&nbsp;валюте «{currency}». Сделку можно привязать только к кампании в&nbsp;рублях.',
                                                    {
                                                        dealId: u._.get(err, 'params.dealIds[0]'),
                                                        currency: u.currencies.getName(
                                                            err.params.currencyCode, { full: true }
                                                        )
                                                    }
                                                );
                                        }
                                    }
                                ]
                            },

                            {
                                path: ['remove_links', idx, 'campaign_id'],
                                codes: [
                                    {
                                        code: 'DefectIds.OBJECT_NOT_FOUND',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'remove-deals-from-not-found-campaign2',
                                                    'Не удалось отвязать сделки {dealIds}. Кампания не&nbsp;найдена.',
                                                    { dealIds: dealIds.join(', ') }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'remove-deal-from-not-found-campaign2',
                                                    'Не удалось отвязать сделку {dealId}. Кампания не&nbsp;найдена.',
                                                    { dealId: dealIds[0] }
                                                );
                                        }
                                    },
                                    {
                                        code: 'CampaignDefectIds.Gen.ARCHIVED_CAMPAIGN_MODIFICATION',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'remove-deals-from-archived-campaign2',
                                                    'Не удалось отвязать сделки {dealIds}. Кампания находится в&nbsp;архиве.',
                                                    { dealIds: dealIds.join(', ') }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'remove-deal-from-archived-campaign2',
                                                    'Не удалось отвязать сделку {dealId}. Кампания находится в&nbsp;архиве.',
                                                    { dealId: dealIds[0] }
                                                );
                                        }
                                    },
                                    {
                                        code: 'CampaignDefectIds.Gen.CANT_REMOVE_DEALS_FROM_ACTIVE_CAMPAIGN',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'remove-deals-from-active-campaign2',
                                                    'Не удалось отвязать сделки {dealIds}. Отвязать сделки можно только от&nbsp;кампании co&nbsp;статусом «Черновик».',
                                                    { dealIds: dealIds.join(', ') }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'remove-deal-from-active-campaign2',
                                                    'Не удалось отвязать сделку {dealId}. Отвязать сделку можно только от&nbsp;кампании co&nbsp;статусом «Черновик».',
                                                    { dealId: dealIds[0] }
                                                );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['remove_links', idx, 'deal_id'],
                                codes: [
                                    {
                                        code: 'DealDefectIds.DEAL_IS_NOT_ACTIVE',
                                        message: function(requestParams, err) {
                                            var dealIds = u._.get(err, 'params.dealIds', []);

                                            return dealIds.length > 1 ?
                                                iget2(
                                                    'deals-selector-popup',
                                                    'removed-deals-is-not-active2',
                                                    'Не удалось отвязать сделки {dealIds}. Сделки должны быть со&nbsp;статусом «Принята».',
                                                    { dealIds: dealIds.join(', ') }
                                                ) :
                                                iget2(
                                                    'deals-selector-popup',
                                                    'removed-deal-is-not-active2',
                                                    'Не удалось отвязать сделку {dealId}. Сделка должна быть со&nbsp;статусом «Принята».',
                                                    { dealId: dealIds[0] }
                                                );
                                        }
                                    }
                                ]
                            }
                        ];
                    },
                    function(obj, err) {
                        return err.message || iget2(
                            'deals-selector-popup',
                            'cant-save-changes2',
                            'При сохранении изменений произошла ошибка. Пожалуйста, попробуйте позже.'
                        );
                    }
                );
            }
        }
    });
})();
