BEM.DOM.decl('deals-selector', {

    onSetMod: {},

    /**
     * Отрисовывает элементы списка (с выбранными элементами на основании `value`)
     * @param {{ id: String, name: String, addition: String }[]} items
     * @param {string[]} value
     */
    drawList: function(items, value) {
        BEM.DOM.replace(
            this.findElem('content'),
            BEMHTML.apply(
                items.length ?
                    {
                        block: 'b-chooser',
                        mix: { block: 'deals-selector', elem: 'content' },
                        mods: { search: 'yes', theme: 'checkboxes', multi: 'yes' },
                        content: [
                            { elem: 'search' },
                            {
                                block: 'b-overflow-luxury-scroll',
                                mix: { block: 'deals-selector', elem: 'overflow' },
                                js: { bleachHeight: 15 },
                                content: {
                                    block: 'b-chooser',
                                    elem: 'wrap',
                                    mods: { search: 'yes', theme: 'checkboxes' },
                                    mix: { block: 'deals-selector', elem: 'wrap-items' },
                                    content: items
                                        .sort(function(a, b) { return b.id - a.id; })
                                        .map(function(item) {
                                            return {
                                                elem: 'item',
                                                elemMods: {
                                                    selected: u._.includes(value, item.id) ? 'yes' : '',
                                                    disabled: item.isDisabled ? 'yes' : ''
                                                },
                                                js: { search: u._.pick(item, ['name', 'addition']) },
                                                name: item.id,
                                                content: [
                                                    {
                                                        block: 'deals-selector',
                                                        elem: 'name',
                                                        mix: { block: 'b-chooser', elem: 'name' },
                                                        content: item.name
                                                    },
                                                    item.addition ?
                                                        {
                                                            block: 'deals-selector',
                                                            elem: 'addition',
                                                            mix: { block: 'b-chooser', elem: 'addition' },
                                                            content: item.addition
                                                        } :
                                                        ''
                                                ]
                                            };
                                        })
                                }
                            },
                            {
                                elem: 'not-found',
                                content: {
                                    block: 'b-emptiness',
                                    mix: { block: 'deals-selector', elem: 'not-found' },
                                    title: iget2(
                                        'deals-selector',
                                        'deals-not-found-title',
                                        'Не нашлось ни одной сделки'
                                    ),
                                    detail: iget2(
                                        'deals-selector',
                                        'deals-not-found-detail',
                                        'Убедитесь, что в запросе нет ошибок или попробуйте уменьшить длину&nbsp;запроса'
                                    )
                                }
                            }
                        ]
                    } :
                    {
                        block: 'b-emptiness',
                        mix: {
                            block: 'deals-selector',
                            elem: 'dont-have-deals-message'
                        },
                        title: iget2(
                            'deals-selector',
                            'dont-have-deals-title-list',
                            'Заключите сделки с издателями из {list}',
                            {
                                list: function(text) {
                                    return {
                                        block: 'link',
                                        target: '_blank',
                                        url: u.formatUrl({
                                            host: u.url.getRegionalDomain(),
                                            path: '/adv/partners/private-deals-publishers'
                                        }),
                                        content: text
                                    };
                                }(iget2('b-private-deals','izdat-list', 'списка')),

                                context: 'link - списка'
                            }
                        ),
                        detail: iget2(
                            'deals-selector',
                            'dont-have-deals-detail',
                            'Все ваши сделки будут отображаться на этом экране'
                        )
                    }
            )
        );
    },

    /**
     * Ставит фокус в поле поиска
     */
    focusSearch: function() {
        this.blockInside('b-chooser') && this.blockInside('b-chooser').getInput().setMod('focused', 'yes');
    },

    /**
     * Обработчик выбора в `b-chooser`
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {string} data.name
     * @param {boolean} data.selected
     * @private
     */
    _onChoose: function(e, data) {
        if (u._.get(data, 'source') !== 'deals-selector') {
            this.trigger('choose', {
                itemId: data.name,
                isSelected: data.selected,
                value: e.block.val() ? [e.block.val()] : []
            });
        }
    },

    /**
     * Устанавливает значение
     * @param {string[]} ids
     */
    setChoice: function(ids) {
        var bChooser = this.blockInside('b-chooser');

        bChooser.getAll('selected').forEach(function(itemParams) {
            bChooser.uncheck(itemParams.name, { source: 'deals-selector' })
        });

        if (ids.length) {
            ids.forEach(function(id) {
                bChooser.check(id, { source: 'deals-selector' });
            });
        }
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('change', 'b-chooser', function(e, data) {
                this._onChoose(e, data)
            })
            .liveBindTo('addition', 'click', function(e) {
                //игнорируем клик по id'шнику сделки для её выделения и копирования
                e.stopImmediatePropagation();
            });

        return false;
    }

});
