BEM.MODEL.decl('dm-base-banner', {

    modelId: 'id',

    // Идентификатор объявления, если его еще нет - должен быть равен '0'
    bid: {
        type: 'string',
        default: '0'
    },

    // Идентификатор объявления в БК
    BannerID: 'string',

    // Признак нового баннера (данных о нем нет на бекэнде)
    isNewBanner: {
        type: 'boolean',
        default: false
    },

    //тип баннера - мобильный или десктопный: desktop|mobile
    banner_type: { type: 'string', default: 'desktop' },

    // флаг редко используемых баннеров
    is_bs_rarely_loaded: 'string',

     // флаг для показа супер ролям расширенной информации
    showAdminAttrs: { type: 'boolean', internal: true },

    // Статус показов объявления
    statusShow: {
        type: 'enum',
        enum: [
            'Yes',
            'No'
        ]
    },

    // Статус модерации условия, приходит как statusModerate у объекта группы
    groupStatusModerate: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sent',
            'Sending',
            'Ready',
            'New'
        ],
        default: 'New'
    },

    // Статус синхронизации с крутилкой
    statusBsSynced: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sending'
        ],
        default: 'No'
    },

    // Статус модерации объявления
    statusModerate: {
        type: 'enum',
        enum: [
            'Yes',
            'No',
            'Sent',
            'Sending',
            'Ready',
            'New'
        ],
        default: 'New'
    },

    // Флаг, означающий можно ли отправлять баннер в БК
    statusPostModerate: {
        type: 'enum',
        enum: [
            'Yes', // отправлять можно
            'No', // отправлять нельзя (кроме случая остановки активного баннера)
            'Sent',
            'Ready',
            'Rejected', // нужно отправить в БК с флагом остановки объявления
            'New'
        ],
        default: 'No'
    },

    // Статус модерации текстом, приходит с бекэнда
    status: 'string',

    // может ли баннер показываться при выполнении других условий показа
    statusActive: {
        type: 'enum',
        enum: [
            'Yes',
            'No'
        ],
        default: 'No'
    },

    // Объявление находится в архиве
    archive: {
        type: 'enum',
        enum: [
            'Yes',
            'No'
        ],
        default: 'No'
    },

    // возможность удалить баннера (с сервера)
    can_delete_banner: {
        type: 'boolean',
        default: false
    },

    // возможность заархивировать баннер
    can_archive_banner: {
        type: 'boolean',
        dependsFrom: ['archive', 'BannerID', 'statusShow', 'statusModerate'],
        calculate: function() {
            return this.get('archive') === 'No' && this.get('statusShow') === 'No' &&
                (this.get('BannerID') !== '0' || this.get('statusModerate') !== 'New');
        }
    },

    /**
     * Заголовок и текст объявления до автоисправления в модерации
     * @param {Object} before_moderation
     * @param {String} before_moderation.title
     * @param {String} before_moderation.body
     * @param {'Yes'|'No'} before_moderation.showModEditNotice Флаг о показе версии до исправления опечаток
     */
    before_moderation: {
        type: 'object'
    },

    // Флаг о том что больше не нужно показывать версию до исправления опечаток
    disabledAutocorrectionWarning: {
        type: 'boolean',
        default: false
    },

    //cyn@TODO: временно, иначе падает подписка в b-banner-status_updatable_yes
    autobudget: 'string',
    statusAutobudgetShow: 'string',
    // Нужно для b-banner-status
    // дневной бюджет
    day_budget: 'string',
    day_budget_show_mode: 'string',
    // дневной бюджет на основной счет
    wallet_day_budget: 'string',
    wallet_day_budget_show_mode: 'string'

}, {

    /**
     * Устанавливает флаги предупреждений в модель баннера
     * на вход принимает объект c предупреждениями, выставляет их в порядке следования в объекте
     * если новый флаг зависимый, то существующие зависимые флаги снимаются
     * пример: `modelBanner.setFlag({ baby_food: 10, age: 10, alcohol: '1' })` > `{ age: 10, alcohol: '1' }`
     * чтобы сбросить флаг, в качестве значения в объекте должно быть `-1`, например `modelBanner.setFlag({ baby_food: '-1' })`
     * @param {Object} newFlags Объект с ключами и значениями, которые необходимо установить
     * @param {Object} [data] дополнительные параметры доступные в обработчиках событий `change`
     * @returns {BEM.MODEL}
     */
    setHashFlagsWithDependencies: function(newFlags, data) {
        if (this.fieldsDecl['hash_flags']) {
            var newFlagsKeys = u._.isObject(newFlags) ? Object.keys(newFlags) : [],
                resultValue = u._.extend({}, this.get('hash_flags'));

            if (newFlagsKeys.length) {
                newFlagsKeys.forEach(function(objectKey) {
                    var objectKeyData = u.consts('AD_WARNINGS')[objectKey];

                    if (objectKeyData) {
                        var objectValue = newFlags[objectKey],
                            isResetValue = objectValue == -1,
                            isCommonWarn = objectKeyData.is_common_warn;

                        // Если флаг не общий и не нужно сбросить существующий флаг -
                        // сбрасываем все зависимые предупреждения, оставляем только общие
                        !isCommonWarn && !isResetValue && Object.keys(resultValue).forEach(function(key) {
                            if (u.consts('AD_WARNINGS')[key] && !u.consts('AD_WARNINGS')[key].is_common_warn) {
                                resultValue[key] = null;
                            }
                        });

                        resultValue[objectKey] = isResetValue ? null : objectValue;
                    }
                });

                // фильтруем флаги со значением null
                resultValue = Object.keys(resultValue).reduce(function(result, key) {
                    resultValue[key] === null || (result[key] = resultValue[key]);

                    return result;
                }, {});

                this.set('hash_flags', resultValue, data);
            }
        }

        return this;
    }

});
