(function() {
    var errorText = iget2('dm-base-campaign', 'nevernoe-znachenie-urovnya-ostatka', 'Неверное значение уровня остатка средств'),
        boolToFlag = function(val) {
            return +(!!val);
        };

    BEM.MODEL.decl('dm-base-campaign', {
        active_orders_money_out_sms: { type: 'boolean', preprocess: boolToFlag },
        active_orders_money_warning_sms: { type: 'boolean', preprocess: boolToFlag },
        camp_banners_domain: 'string',
        cid: 'string',
        ClientID: 'string',

        //--- sms-оповещения

        //телефон для смс-уведомлений
        sms_phone: 'string',
        //время для смс-уведомлений
        sms_time_hour_from: 'number',
        sms_time_hour_to: 'number',
        sms_time_min_from: 'number',
        sms_time_min_to: 'number',
        //sms оповещение об окончании кампании
        camp_finished_sms: { type: 'boolean', preprocess: boolToFlag },
        //sms оповещение о результатах мониторинга сайтов
        notify_metrica_control_sms: { type: 'boolean', preprocess: boolToFlag },
        //sms оповещение о поступлении средств
        notify_order_money_in_sms: { type: 'boolean', preprocess: boolToFlag },
        //sms оповещение о результатах модерации
        moderate_result_sms: { type: 'boolean', preprocess: boolToFlag },
        //sms оповещение об остановке по достижению дневного бюджета
        paused_by_day_budget_sms: { type: 'boolean', preprocess: boolToFlag },
        //--- sms-оповещения

        // Показы на тематических площадках запрещены
        dontShowYacontext: 'string',
        //Показы останавливаются при отключении фраз на поиске.
        statusContextStop: 'string',
        //-- настройки на тематических площадках

        // Кампания находится в валютном спецархиве
        currency_archived: 'number',

        currency: 'string',

        //показывать 1-е спецразмещение для фраз на данной кампании
        showPmax: 'boolean',
        // @deprecated
        day_budget: 'number',
        // @deprecated
        day_budget_show_mode: 'string',
        // настройка "Дневной бюджет"
        day_budget2: {
            type: 'model',
            modelName: 'dm-day-budget2'
        },

        // настройка "модель атрибуции"
        attribution_model: {
            type: 'enum',
            enum: ['last_yandex_direct_click', 'last_significant_click', 'last_click', 'first_click'],
            default: 'last_yandex_direct_click'
        },

        // включена оплата за конверсии

        isCpaPayForConversionEnabled: 'boolean',

        // стратегия кампании
        strategy2: {
            type: 'model',
            modelName: 'dm-campaign-strategy2'
        },
        //Запрещение показов по IP-адресам
        disabledIps: 'string',
        //Запрещённые площадки
        DontShow: 'array',

        // доступные ssp-площадки
        ssp_platforms: 'array',
        // заблокированные ssp-площадки
        disabled_ssp: 'array',

        //Название клиента
        fio: 'string',

        //Возможность редактировать баннеры, allow_edit_camp(s) на страницах статистики
        editable: 'boolean',

        // @deprecated
        is_autobudget: 'boolean',
        //тип кампании 'text, 'mobile_content', и т.п.
        mediaType: 'string',

        minus_words: {
            type: 'array',
            default: []
        },

        //--- Уведомления по email
        //email для уведомлений
        email: 'string',
        //получать уведомления на email через каждые...
        warnPlaceInterval: 'string',
        //Уведомления об остановке по достижению дневного бюджета
        email_notify_paused_by_day_budget: { type: 'boolean', preprocess: boolToFlag },
        //Уведомлять при уровне остатка средств на&nbsp;кампании
        money_warning_value: {
            type: 'number',
            precision: 0,
            validation: {
                rules: {
                    required: errorText,
                    type: errorText,
                    lte: {
                        needToValidate: function() {
                            return !this.get('wallet_cid');
                        },
                        value: 1,
                        text: errorText
                    },
                    gte: {
                        needToValidate: function() {
                            return !this.get('wallet_cid');
                        },
                        value: u.consts('MAX_MONEY_WARNING_VALUE'),
                        text: errorText
                    }
                }
            }
        },
        //Уведомления о событиях по этой кампании (обслуживание персональным менеджером)
        sendAccNews: { type: 'boolean', preprocess: boolToFlag },
        //Получать предупреждения о смене позиции
        sendWarn: { type: 'boolean', preprocess: boolToFlag },
        //Уведомления о готовности XLS-отчетов
        offlineStatNotice: { type: 'boolean', preprocess: boolToFlag },
        //--- Уведомления по email

        //Название кампании
        name: {
            type: 'string',
            validation: {
                rules: {
                    required: {
                        text: iget2('dm-base-campaign', 'ne-zapolneno-pole-nazvanie', 'Не заполнено поле "Название кампании"')
                    }
                }
            }
        },
        //id для общего счета
        wallet_cid: 'string',
        nobsdata: 'boolean', // флаг говорящий о том, что бк не отвечает (DIRECT-21557)

        // @deprecated
        net_strategy: 'string',

        phrases_inited: 'boolean',
        // @deprecated
        places_strategy: { type: 'string', default: 'search' },
        platform: 'string',
        platform_select: 'boolean',
        product_type: 'string',
        readonly: 'boolean',

        // @deprecated
        search_strategy: 'string',

        spent_today: { type: 'number' },
        //дата начала кампании
        start_date: {
            type: 'string',
            validation: {
                rules: {
                    required: {
                        text: iget2('dm-base-campaign', 'vy-dolzhny-ukazat-datu', 'Вы должны указать дату старта кампании')
                    }
                }
            }
        },
        //дата окончания кампании
        finish_date: 'string',

        // @deprecated
        strategy: 'object',
        // @deprecated
        strategy_name: 'string',
        sum_rest: { type: 'number', default: 0 },
        tags: { type: 'models-list', modelName: 'm-campaign-tag', defaults: { value: [] } },
        //какая-то константа из временного таргетинга, используется для расчета ставки
        timetarget_coef: 'string',
        title: 'string',
        ulogin: 'string',
        untagged_banners_num: { type: 'number', precision: 0 },

        // флаг, показывающий, заархивирована ли кампания (заполняется только на странице кампании)
        // cyn@TODO: переделать на archived
        campaignIsArchived: 'boolean',
        // флаг, показывающий, заархивирована ли кампания (приходит с сервера)
        archived: {
            type: 'enum',
            enum: ['Yes', 'No'],
            default: 'No'
        },
        currentTab: 'string',
        countArchTab: 'number',
        countOffTab: 'number',

        //установлен общий регион на кампанию
        common_geo_set: 'boolean',
        //значение общего региона на кампанию, если он установлен
        common_geo: 'string',

        // включен ли для кампании автобюджет
        autobudget: 'string',
        //число групп в кампании todo - переименовать в groups_count DIRECT-47940
        banners_count: 'number',

         // Объявлений на страницу. todo - переименовать в groups_per_page DIRECT-47940
        banners_per_page: 'string',

        isCampShows: 'boolean',

        //используется на странице просмотра кампании
        //adgroup_id выбранных в текущий момент в интерфейсе баннеров
        selectedAdgroupIds: 'array',
        //список всех групп, входящих в кампанию
        allAdgroupIds: 'array',
        new_camp: 'boolean',
        //тип группы кампаний на списке кампаний - например 3_self
        groupId: 'string',

        // минимально допустимый бюджет за выбранный период
        strategy_with_custom_period_min_available_budget: 'number',
        //Сумма указанная пользователем как сумма к оплате
        sumInput: {
            type: 'blank-number',
            precision: 2,
            internal: true,
            validation: {
                rules: {
                    type: {
                        text: iget2('dm-base-campaign', 'nepravilno-ukazana-summa', 'Неправильно указана сумма')
                    },
                    min: {
                        value: 0,
                        text: iget2('dm-base-campaign', 'nepravilno-ukazana-summa', 'Неправильно указана сумма')
                    }
                },
                needToValidate: function() {
                    //0 - это нормальное значение, которое надо валидировать
                    return !!this.get('sumInput') || this.get('sumInput') === 0;
                }
            }
        },
        // идентификатор заказа в БК
        OrderID: 'string',
        // включить/выключить фильтрацию площадок для показа по списку запрещенных доменов
        require_filtration_by_dont_show_domains: 'boolean'

    }, {

        /**
         * Возвращает название для дочерних моделей групп
         * @returns {string}
         */
        getChildGroupModelName: function() {
            return u.campaign.getGroupModelName(this.get('mediaType'));
        },

        /**
         * Возвращает дочерние модели групп по их adgroup_id
         * @param {Array} adgroupsIds
         * @returns {MODEL}
         */
        getChildGroupsByIds: function(adgroupsIds) {
            var modelName = this.getChildGroupModelName();

            return adgroupsIds.map(function(id) {
                return BEM.MODEL.getOrCreate({ id: id, name: modelName })
            });
        },

        /**
         * Возвращает дочернюю группу по ее id
         * @param {String} adgroupId
         * @returns {BEM.MODEL}
         */
        getChildGroupById: function(adgroupId) {
            return BEM.MODEL.getOrCreate({ name: this.getChildGroupModelName(), id: adgroupId });
        },

        /**
         * Возвращает массив с группами, выбранными в текущий момент в интерфейсе
         * @returns {Array}
         */
        getSelectedGroups: function() {
            return this.get('selectedAdgroupIds').map(function(adgroupId) {
                return this.getChildGroupById(adgroupId);
            }, this)
        },

        isOffTab: function() {
            return this.get('currentTab') === 'off';
        },
        isArchiveTab: function() {
            return this.get('currentTab') === 'arch';
        },

        isStopOnContext: function() {
            return this.get('dontShowYacontext') == 'Yes';
        }
    });
})();
