(function() {
    var request = function(method, data) {
            var dfd = $.Deferred();

            BEM.create('i-request_type_ajax', {
                cache: false,
                url: '/registered/main.pl',
                dataType: 'json',
                callbackCtx: this
            }).get(
                data,
                function(result) { result.error ? dfd.reject(result.error) : dfd.resolve(result) },
                function(err) { dfd.reject(err) },
                { type: method.toLowerCase() });

            return dfd.promise();
        },
        doCmd = function(cmd, params) {
            params.csrf_token = u.consts('csrf_token');

            document.location = u.getUrl(cmd, params);
        },
        notStatus200Error = new Error('Response not success');

    BEM.MODEL.decl('dm-base-group', {

        // Идентификатор группы
        modelId: 'id',

        // Идентификатор кампании
        cid: { type: 'string', internal: true },

        //имя группы
        group_name: {
            type: 'string',
            validation: {
                rules: {
                    required: { text: iget2('dm-base-group', 'ne-ukazano-nazvanie-gruppy', 'Не указано название группы') }
                }
            }
        },

        // необходимо для general_limit_price (в блоке b-edit-phrase-price)
        campDMName: {
            type: 'string',
            internal: true
        },

        has_general_limit_price: {
            type: 'boolean',
            default: false
        },

        // инпут «Ограничение ставки» для фраз на группу
        general_limit_price: {
            type: 'number',
            validation: function() {
                var currencyName = this.getCurrency(),
                    campaignModel = this.getCampaignModel(),
                    limits = u.bids.getLimits(campaignModel.name, currencyName),
                    isNewGroup = this.get('isNewGroup'),
                    isManualPriceSettingType = this.get('has_general_limit_price');

                return {
                    rules: {
                        gte: {
                            value: limits.maxPrice.value,
                            text: limits.maxPrice.errorText
                        },
                        lte: {
                            value: limits.minPrice.value,
                            text: limits.minPrice.errorText
                        },
                        required: {
                            text: iget2('dm-base-group', 'missing_general_limit_price', 'Необходимо указать максимальную ставку')
                        }
                    },
                    needToValidate: function(value) {
                        //старое условие всегда падало в false, возвращаем
                        //return isManualPriceSettingType && ((isNewRmpEnabled && isNewGroup) || (value !== undefined));
                        return false;
                    }
                };
            }
        },

        // Число баннеров в группе, включая архивные
        banners_quantity: 'number',

        // Число только архивных баннеров в группе
        banners_arch_quantity: 'number',

        // Массив всех типов баннеров в группе с указанием их количества
        group_banners_types: 'array',

        // Идентификатор группы
        adgroup_id: {
            type: 'string',
            preprocess: function(val) {
                // всегда строка
                return val || val === 0 ? val + '' : '';
            }
        },

        // Тип группы
        adgroup_type: 'string',

        // Баннеры группы
        banners: {
            type: 'models-list'
            //modelName: 'm-banner'
        },

        // Минус-слова на группу
        minus_words: {
            type: 'array',
            default: []
        },

        // Результат модерации списка фраз и гео (условия показа)
        statusModerate: {
            type: 'enum',
            enum: [
                'Yes',
                'No',
                'Sent',
                'Sending',
                'Ready',
                'New'
            ],
            default: 'New'
        },

        // Флаг, означающий можно ли отправлять фразы в БК
        statusPostModerate: {
            type: 'enum',
            enum: [
                'Yes', // отправлять можно
                'No', // отправлять нельзя (кроме случая остановки активного баннера)
                'Sent',
                'Ready',
                'Rejected', // нужно отправить в БК с флагом остановки объявления
                'New'
            ],
            default: 'No'
        },

        //Флаг "Остановлено мониторингом сайта"
        statusMetricaStop: {
            type: 'enum',
            enum: [
                'Yes',
                'No'
            ],
            default: 'No'
        }
    }, {

        request: request,

        /**
         * Возвращает модели баннеров, принадлежащих данной группе
         * @returns {BEM.MODEL[]}
         */
        getBanners: function() {
            return this.get('banners', 'raw');
        },

        needToValidateGeneralLimitPrice: function(value) {
            return value !== undefined;
        },

        /**
         * Возвращает массив моделей дочерних баннеров, соответствующих заданным параметрам.
         * @param {Object} condition Объект, задающий условия поиска
         * @returns {BEM.MODEL[]}
         */
        getBannersWhere: function(condition) {
            return this.get('banners').where(condition);
        },

        /**
         * Возвращает модель дочернего баннера по его `bid`
         * @param {String|Number} bid
         * @returns {BEM.MODEL}
         */
        getBannerByBid: function(bid) {
            return this.getBannersWhere({ bid: +bid })[0];
        },

        /**
         * Возвращает модель дочернего баннера по идентификатору модели
         * @param {String|Number} modelId
         * @returns {BEM.MODEL}
         */
        getBannerByModelId: function(modelId) {
            return this.get('banners').getById(modelId);
        },

        /**
         * Отправляет запрос на установку новых статусов для баннеров по массиву id баннеров
         * @param {Object[]} statuses - Массив содержащий статусы для баннеров соответствующих id
         * @returns {$.Deferred}
         */
        bulkSetBannerStatusById: function(statuses) {
            // структура statuses: statuses[{ bid: 1, value: true }, ...];
            // где bid - id баннера, а value - значение статуса

            return request('POST', {
                cmd: 'setBannersStatuses',
                adgroup_id: this.get('adgroup_id'),
                ulogin: u.consts('ulogin'),
                json_statuses: JSON.stringify(statuses.reduce(function(prev, next) {
                    prev[next.bid] = { statusShow: next.value ? 'Yes' : 'No' };

                    return prev;
                }, {}))
            })
                .then(function(result) {
                    if (!result || !result.success)
                        return $.Deferred().rejectWith(notStatus200Error);

                    statuses.forEach(function(status) {
                        this.getBannerByBid(status.bid).set('statusShow', status.value ? 'Yes' : 'No');
                    }, this);

                    return true;
                }.bind(this));
        },

        /**
         * Архивирует баннер по его id
         * @param {String} bid - id баннера
         * @returns {$.Deferred}
         */
        archiveBannerById: function(bid) {
            return request('GET', {
                cmd: 'archiveBanner',
                ulogin: u.consts('ulogin'),
                adgroup_ids: this.get('adgroup_id'),
                cid: this.get('cid'),
                bid: bid,
                format: 'json',
                archive_whole_group: 0
            })
                .then(function(result) {
                    if (!result || result.status !== 'success')
                        return $.Deferred().rejectWith(notStatus200Error);

                    this.getBannerByBid(bid).set('archive', 'Yes');

                    this.set('banners_arch_quantity', this.get('banners_arch_quantity') + 1);
                }.bind(this));
        },

        /**
         * Архивирует баннер по id c перезагрузкой страницы и редиректом.
         * @param {String} bid - id баннера.
         */
        archiveBannerByIdWithRedirect: function(bid) {
            doCmd('archiveBanner', {
                adgroup_ids: this.get('adgroup_id'),
                ulogin: u.consts('ulogin'),
                cid: this.get('cid'),
                bid: bid
            });
        },

        /**
         * Разархивирует баннер по его id
         * @param {String} bid - id баннера
         * @returns {$.Deferred}
         */
        unArchiveBannerById: function(bid) {
            return request('GET', {
                cmd: 'unarchiveBanner',
                ulogin: u.consts('ulogin'),
                adgroup_ids: this.get('adgroup_id'),
                cid: this.get('cid'),
                bid: bid,
                format: 'json',
                unarchive_whole_group: 0
            })
                .then(function(result) {
                    if (!result || result.status !== 'success')
                        return $.Deferred().rejectWith(notStatus200Error);

                    this.getBannerByBid(bid).set('archive', 'No');

                    this.set('banners_arch_quantity', this.get('banners_arch_quantity') - 1);
                }.bind(this));
        },

        /**
         * Разархивирует баннер по id c перезагрузкой страницы и редиректом.
         * @param {String} bid - id баннера.
         */
        unArchiveBannerByIdWithRedirect: function(bid) {
            doCmd('unarchiveBanner', {
                adgroup_ids: this.get('adgroup_id'),
                ulogin: u.consts('ulogin'),
                cid: this.get('cid'),
                bid: bid
            });
        },

        /**
         * Разархивирует всю группу
         * @returns {$.Deferred}
         */
        unArchiveAllBanners: function() {
            return request('GET', {
                cmd: 'unarchiveBanner',
                ulogin: u.consts('ulogin'),
                adgroup_ids: this.get('adgroup_id'),
                cid: this.get('cid'),
                format: 'json',
                unarchive_whole_group: 1
            })
                .then(function(result) {
                    if (!result || result.status !== 'success')
                        return $.Deferred().rejectWith(notStatus200Error);

                    var archiveBanners = this.getBannersWhere({ archive: 'Yes' });

                    archiveBanners.forEach(function(banner) { banner.set('archive', 'No'); });

                    this.set('banners_arch_quantity', this.get('banners_arch_quantity') - archiveBanners.length);
                }.bind(this));
        },

        /**
         * Разархивирует всю группу c перезагрузкой страницы и редиректом.
         */
        unArchiveAllBannersWithRedirect: function() {
            doCmd('unarchiveBanner', {
                adgroup_ids: this.get('adgroup_id'),
                ulogin: u.consts('ulogin'),
                cid: this.get('cid'),
                unarchive_whole_group: 1
            });
        },

        /**
         * Удаляет баннер по его id
         * @param {String} bid - id баннера
         * @returns {$.Deferred}
         */
        deleteBannerById: function(bid) {
            return request('GET', {
                cmd: 'delBanner',
                ulogin: u.consts('ulogin'),
                adgroup_ids: this.get('adgroup_id'),
                cid: this.get('cid'),
                bid: bid,
                format: 'json',
                delete_whole_group: 0
            })
                .then(function(result) {
                    if (!result || result.status !== 'success')
                        return $.Deferred().rejectWith(notStatus200Error);

                    var banner = this.getBannerByBid(bid),
                        isArchive = banner.get('archive') === 'Yes';

                    banner.destruct();

                    this.set('banners_quantity', this.get('banners_quantity') - 1);
                    isArchive && this.set('banners_arch_quantity', this.get('banners_arch_quantity') - 1);
                }.bind(this));
        },

        /**
         * Удаляет баннер по id c перезагрузкой страницы и редиректом.
         * @param {String} bid - id баннера.
         */
        deleteBannerByIdWithRedirect: function(bid) {
            doCmd('delBanner', {
                adgroup_ids: this.get('adgroup_id'),
                ulogin: u.consts('ulogin'),
                cid: this.get('cid'),
                bid: bid
            });
        },

        /**
         * Запрашивает список баннеров группы
         * @param {Boolean} [isArchive=false] тип баннеров
         * @private
         * @returns {$.Deferred}
         */
        _requestGroupData: function(isArchive) {
            return request(
                'GET',
                {
                    cmd: 'getAdGroup',
                    adgroup_id: this.get('adgroup_id'),
                    arch_banners: isArchive ? 1 : 0,
                    ulogin: u.consts('ulogin')
                })
                .then(function(result) {
                    if (!result)
                        return $.Deferred().rejectWith(new Error('Bad response'));

                    return result;
                });
        },

        /**
         * Получает данные по группе с сервера
         * @param {Object} options
         * @param {Boolean} options.isArchive Выбирает архивные баннеры, если значение `true`
         * @param {Boolean} options.onlyBanners Обновляет только данные по баннерам, если значение `true`
         * @returns {$.Deferred}
         */
        requestGroupDataAndUpdate: function(options) {
            var countBannerModels = this.getBannersWhere({ archive: options.isArchive ? 'Yes' : 'No' }).length,
                countBannerModelsMustBe = options.isArchive ?
                    this.get('banners_arch_quantity') :
                    this.get('banners_quantity') - this.get('banners_arch_quantity');

            return options.onlyBanners && countBannerModelsMustBe && (countBannerModelsMustBe === countBannerModels) ?
                $.Deferred().resolve(this).promise() :
                this._requestGroupData(options.isArchive).then(function(data) {

                    if (options.onlyBanners) {
                        var organizations = data.organizations || {};
                        // заполняем только баннеры
                        data.banners.forEach(this.addBannerToList, this);

                        // обновляем организации справочника, если есть данные
                        this.updateOrganizationModels(organizations);

                    } else {
                        // skywhale: DIRECT-58899: ТС: Превью в МОЛе открывается только со второго раза
                        // если нет минуслов, сервер должен присылать пустой массив
                        data.minus_words || (data.minus_words = []);

                        // заполняем все данные по группе
                        this.update(this.dataToModelData(data));
                    }

                    return this;
                }.bind(this));
        },

        /**
         * Добавляет баннер в группу (добавляет ещё одну модель в поле banners (model-list))
         * @param {Object} bannerData объект с серверными данными по баннеру
         * @returns {BEM.MODEL}
         */
        addBannerToList: function(bannerData) {
            var modelData = this.bannerDataToModelData(bannerData);

            return this.getBannerByModelId(modelData.modelId) || this.get('banners').add(modelData);
        },

        /**
         * Удаляет баннер по идентификатору модели
         * @param {String} bannerId
         */
        removeBanner: function(bannerId) {
            this.getBannerByModelId(bannerId).destruct();
        },

        /**
         * Преобразовывает серверные данные по баннеру в модельные
         * !Переопределяется в модификаторах!
         * @returns {Object}
         */
        bannerDataToModelData: function() {
            throw new Error('must be overrided');
        },

        /**
         * Преобразовывает серверные данные по группе в модельные
         * !Переопределяется в модификаторах!
         * @returns {Object}
         */
        dataToModelData: function() {
            throw new Error('must be overrided');
        },

        /**
         * Проверяет один ли баннер остался в группе.
         * @returns {Boolean}
         */
        isLastBanner: function() {
            return this.get('banners_quantity') === 1;
        },

        /**
         * Возвращает модель предыдущего баннера группы
         * Данные - либо последний редактировавшийся баннер из переменной this.data.prev_banner,
         * либо данные из предыдущего баннера группы
         * Если указан параметр adType возвращается модель ближайшего из предыдущих баннеров, совпадающего по типу
         * @param {String} bannerModelId
         * @param {'text'|'image_ad'} [adType] тип баннера
         * @returns {Object}
         */
        getPrevBannerData: function(bannerModelId, adType) {
            var index = this.get('banners')._getIndex(bannerModelId),
                currentBanner = this.getBannerByModelId(bannerModelId),
                prevBanner = index && this.get('banners').getByIndex(index - 1),
                adImagesAreEqual = function(prevBanner, currentBanner) {
                    var prevImage = prevBanner.get('image_ad'),
                        currentImage = currentBanner.get('image_ad'),
                        prevCreative,
                        currentCreative;

                    // если у обоих баннеров заполнены изображения, сравниваем их размеры
                    if (prevImage && prevImage.get('href') && currentImage && currentImage.get('href')) {
                        return prevImage.get('height') == currentImage.get('height') &&
                            prevImage.get('width') == currentImage.get('width');
                    }

                    prevCreative = prevBanner.get('creative');
                    currentCreative = currentBanner.get('creative');

                    // если у обоих баннеров заполнены креативы, сравниваем их размеры
                    if (prevCreative && prevCreative.get('creative_id') && currentCreative &&
                        currentCreative.get('creative_id')) {

                        return prevCreative.get('height') == currentCreative.get('height') &&
                            prevCreative.get('width') == currentCreative.get('width');
                    }

                    // иначе считаем, что формат отличается
                    return false;
                };

            //если это первый баннер в группе
            if (index == 0 && this.get('isSingleGroup')) {
                prevBanner = BEM.MODEL.getOrCreate({
                    name: u.campaign.getBannerModelName(this.get('adgroup_type')),
                    id: 'prev'
                });
            }

            // если баннер уже был сохранен, то копировать нужно данные ближайшего баннера совпадающего по типу баннера
            while (index > 0 && adType && (prevBanner.get('ad_type') !== adType ||
                // если ГО то баннер можно копировать только баннер с такими же размерами
                (prevBanner.get('ad_type') === 'image_ad' && !adImagesAreEqual(prevBanner, currentBanner)))) {

                prevBanner = this.get('banners').getByIndex(--index);
            }

            if (index == 0 && adType && prevBanner.get('ad_type') !== adType) return {};
            if (index == 0 && adType && adType === 'image_ad' && prevBanner.get('ad_type') === adType &&
                !adImagesAreEqual(prevBanner, currentBanner)) {

                return {};
            }

            return prevBanner.toJSONForCopy();
        },

        /**
         * Возвращает инстанс родительской модели кампании.
         *
         * @returns {BEM.MODEL}
         */
        getCampaignModel: function() {
            var campModelName = u.campaign.getCampaignModelName(this.get('adgroup_type'));

            return this._campaignModel || (this._campaignModel = this.get('cid') ?
                BEM.MODEL.getOrCreate({ name: campModelName, id: this.get('cid') }) :
                BEM.MODEL.getOne(campModelName));
        },

        /**
         * Возвращает единаую цену для всех условий показа(«Ограничение ставки»)
         * https://wiki.yandex-team.ru/direct/TechnicalDesign/auto-price/
         * @returns {Object}
         */
        getAutoPriceData: function() {
            var generalLimitPrice = this.get('general_limit_price');

            return generalLimitPrice === undefined ?
                { auto: 1 } :
                { auto: 0, single_price: generalLimitPrice };
        },

        /**
         * Возвращает фразы группы
         * !Переопределяется в наследующей модели группы!
         * @throws
         */
        getPhrasesModels: function() {
            throw new Error('getPhrasesModels must be overrided in ' + this.name);
        },

        /**
         * Возвращает случайную активную модель фразы
         * @returns {BEM.MODEL}
         */
        getRandomActivePhraseModel: function() {
            return u['dm-base-group'].getRandomActivePhrase(this.getPhrasesModels(), function(phraseModel) {
                return !phraseModel.get('is_suspended') && phraseModel.get('state') !== 'declined';
            });
        },

        getCurrency: function() {
            return this.getCampaignModel().get('currency');
        },

        getStrategy: function() {
            return this.getCampaignModel().get('strategy');
        },

        updateOrganizationModels: function(organizations) {
            Object.keys(organizations).forEach(function(permalink) {
                var organizationData = u['m-organization'].transformData({
                        organization: organizations[permalink]
                    }),
                    organizationModel = BEM.MODEL.getOrCreate({
                        name: 'm-organization',
                        id: permalink
                    });

                organizationModel.update(organizationData);
            });
        }
    });
})();
