u.register({

    'dm-base-group': {

        /**
         * Выбирает случайную активную фразу
         * @param {Object[]} phrases массив фраз
         * @param {Function} suspendedGetter функция определяющая активна фраза или нет
         * @returns {Object}
         */
        getRandomActivePhrase: function(phrases, suspendedGetter) {
            suspendedGetter || (suspendedGetter = function(phrase) {
                // свойство is_suspended от сервера может приходить строкой,
                // поэтому явно преобразуем параметр к числу
                return !+phrase.is_suspended && phrase.state !== 'declined';
            });

            return u.pickRandom(phrases.filter(function(phrase) {
                return suspendedGetter(phrase);
            }));
        }
    }
});
