/**
 * Модель стратегии кампании
 */
BEM.MODEL.decl({ model: 'dm-campaign-strategy2' }, {

    // название (идентификатор) стратегии
    name: 'string',

    // настройки стратегии
    options: 'object',

    // автобюджет
    is_autobudget: {
        type: 'boolean',
        dependsFrom: ['name', 'options'],
        calculate: function() {
            var name = this.get('name'),
                options = this.get('options') || {},
                autoBudgetRegExp = /autobudget/;

            return name === 'different_places' ?
                (autoBudgetRegExp.test((options.search || {}).name) ||
                    autoBudgetRegExp.test((options.net || {}).name)) :
                autoBudgetRegExp.test(name);
        }
    },

    // отключены показы в сетях
    is_net_stopped: {
        type: 'boolean',
        default: false
    },

    // отключены показы на поиске
    is_search_stopped: {
        type: 'boolean',
        default: false
    },

    lastStrategyChange: 'string'
}, {

    /**
     * Возвращает модель кампании
     * @returns {BEM.MODEL}
     */
    getCampaign: function() {
        var pathArray = this._path.split('.'),
            modelParams = pathArray[pathArray.length - 2].split(':');

        return BEM.MODEL.getOne({
            name: modelParams[0],
            id: modelParams[1]
        });
    }

});
