BEM.MODEL.decl({ model: 'dm-content-promotion-banner', baseModel: 'dm-base-banner' }, Object.assign(
    {},
    u['b-content-promotion-video-href'].getModelFields(true),
    u['b-content-promotion-collection-href'].getModelFields(true),
    {
        ad_type: {
            type: 'string',
            default: 'content_promotion'
        },

        content_promotion_content_type: {
            type: 'enum',
            enum: [
                'video',
                'collection'
            ]
        },

        geo_id: 'string',

        //Статус, описывающий синхронность объявления в Директе и БК.
        statusBsSynced: {
            type: 'enum',
            enum: [
                'Yes',
                'No',
                'Sending'
            ]
        },

        newBannerIndex: {
            type: 'number'
        },

        href_model: {
            type: 'model',
            modelName: 'm-banner-href',
            value: {},
            validation: {
                rules: {
                    deep: {
                        text: function(model) {
                            return model.validate().errors
                                .map(function(error) { return error.text; })
                                .join('\n');
                        }
                    }
                }
            },

        },

        //имеет ссылку "скопировать из предыдущего"
        hasCopyFromPrev: { type: 'boolean', internal: true },

        isNewBanner: { type: 'boolean', internal: false }

    }
), {
    provideData: function() {
        var data = this.toJSON(),
            result = {};

        result.hasCopyFromPrev = this.get('hasCopyFromPrev');

        result.ad_type = data.ad_type;
        result.banner_type = data.ad_type;
        if (data.bid && data.bid != 0) {
            result.bid = data.bid;
        }

        switch (data.content_promotion_content_type) {
            case 'video':
                if (data.video_href) {
                    result.content_resource = {
                        content_id: data.content_promotion_video_id
                    };
                }
                result.title = data.title;
                result.description = data.description;
                break;

            case 'collection':
                if (data.collection_href) {
                    result.content_resource = {
                        content_id: data.content_promotion_collection_id
                    };
                }
                break;

        }

        if (data.href_model.href) {
            result.visit_url = data.href_model.url_protocol + data.href_model.href;
        }

        return result;
    },

    toJSONForCopy: function() {
        return u._.omit(this.toJSON(), 'modelId', 'bid', 'BannerID', 'isNewBanner', 'newBannerIndex');
    }
});
