BEM.MODEL.decl({ model: 'dm-content-promotion-group', baseModel: 'dm-base-group' }, {
    //Количество редактируемых баннеров
    edit_banners_quantity: 'number',
    // тип кампании
    camp_type: 'string',
    adgroup_type: {
        type: 'string',
        default: 'content_promotion'
    },

    // тип партнерского контента
    content_promotion_content_type: {
        type: 'enum',
        enum: [
            'video',
            'collection'
        ]
    },
    //Список баннеров
    banners: {
        type: 'models-list',
        modelName: 'dm-content-promotion-banner'
    },
    // Идентификаторы баннеров в группе
    bannersIds: {
        type: 'array',
        internal: true,
        dependsFrom: 'banners',
        calculate: function() {
            return this.getBanners().map(function(banner) {
                return '' + banner.id;
            });
        }
    },
    //метки на группу объявлений
    tags: { type: 'models-list', modelName: 'm-group-tag' },
    // список id показываемых баннеров
    shownBids: { type: 'array', default: [] },
    //нужно для корректной обработки ошибок
    phrases: 'string',
    // список id фраз в баннере
    phrasesIds: { type: 'array', default: [], internal: true },
    //показывать в превью свежие добавленные баннеры
    showNewBanners: 'boolean',
    //список новых фраз
    new_phrases: {
        type: 'array',
        internal: true,
        validation: {
            rules: {
                hasActive: {
                    text: function() {
                        return iget2('dm-content-promotion-group', 'dlya-gruppy-neobhodimo-zadat', 'Для группы необходимо задать ключевые фразы');
                    },

                    validate: function() {
                        var count = 0,
                            state;

                        if (this.get('new_phrases').length > 0) return true;

                        this.getPhrasesModels().map(function(model) {
                            state = model.get('state');

                            if (state !== 'low_ctr' && state !== 'declined' && !model.get('is_suspended') &&
                                !model.get('is_deleted') && model.get('phrase')) {

                                count++
                            }
                        }, this);

                        return !!count;
                    },

                    needToValidate: function() {
                        return !this.get('has_relevance_match');
                    }
                },
                phraseCount: {
                    text: function() {
                        var limit = this.getKeywordLimit();
                        return u.pluralForms(iget2(
                            'dm-content-promotion-group',
                            'gruppa-dolzhna-soderzhat-ne',
                            'Группа должна содержать не более {foo} {ключевой фразы|ключевых фраз|ключевых фраз}',
                            {
                                foo: limit
                            }
                        ), limit);
                    },
                    validate: function() {
                        return this.getPhrasesLeft() >= 0;
                    }
                }
            }
        }
    },
    // дневной бюджет
    day_budget: 'string',
    // кампания на автобюджетной стратегии
    autobudget: 'string',
    //статусы модерации на группу.
    status: 'string',
    // статус модерации: группа активна
    statusActive: 'string',
    // флаг, что группа не остановлена
    statusShow: 'string',
    // можно ли редактировать баннер
    isBannersEditable: 'boolean',
    //группа находится в архивной кампании
    is_camp_archived: 'number',
    //у фраз в группе могут редактироваться ставки
    isBidable: { type: 'boolean', internal: true },
    // можно просмотривать id картинки
    canViewImageId: { type: 'boolean', internal: true },
    //находимся на странице редактирования одной группы
    isSingleGroup: { type: 'boolean', internal: true },
    //идет копирование группы
    isCopyGroup: { type: 'boolean' },
    // индекс новой группы
    newGroupIndex: { type: 'number' },
    // группа новая
    isNewGroup: { type: 'boolean' },
    // флаг об остановке мониторинга сайта
    statusMetricaStop: 'string',

    has_relevance_match: {
        type: 'boolean',
        default: false
    }

}, {
    getActivePhrasesCount: function() {},
    getLowCtrPhrasesCount: function() {},
    getDeclinedPhrasesCount: function() {},

    /**
     * Возвращает все фразы группы
     * @returns {Array}
     */
    getAllPhrases: function() {
        return [].concat(this.get('new_phrases'), this.getPhrases());
    },

    /**
     * Возвращает количество старых фраз
     * @returns {Number}
     */
    getPhrasesLength: function() {
        return this.getPhrases().join(',').length;
    },

    /**
     * добавление баннера
     * @param {Object} defaults - дефолтные данные (для пустого баннера)
     * @returns {BEM.MODEL}
     */
    addBanner: function(defaults) {
        // отфильтровываем только новые баннеры, чтобы сделать для них свою нумерацию
        var newBanners = this.getBannersWhere({ isNewBanner: true }),
            // для нового баннера берём номер предыдущего(последнего) нового баннера в списке,
            // чтобы не было проблем после удаления одного из ранее созданных
            newBannerIndex = newBanners.length ?
                +newBanners[newBanners.length - 1].get('newBannerIndex') + 1 :
                1,
            newBannerId = 'new' + newBannerIndex, // для клиентов показываем отсчёт новых баннеров с 1
            modelData = u._.extend({}, defaults, {
                bid: 0,
                newBannerIndex: newBannerIndex,
                isNewBanner: true,
                modelId: newBannerId,
                hasCopyFromPrev: true,
                content_promotion_content_type: this.get('content_promotion_content_type')
            });

        return this.addBannerToList(modelData);
    },

    /**
     * Возвращает массив с данными по фразам, содержащимся в данной группе
     * @returns {Array}
     */
    getPhrasesData: function() {
        var _this = this,
            phrases = this.get('phrasesIds').reduce(function(goodPhrases, id) {
                var model = BEM.MODEL.getOrCreate({
                    name: _this.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
                    id: id,
                    parentModel: _this
                });

                // DIRECT-40060
                // исключаем пустые фразы
                model.get('phrase') && goodPhrases.push(u._.omit(model.toJSON(), ['param1', 'param2']));

                return goodPhrases;
            }, []),
            newPhrases = this.get('new_phrases');

        if (newPhrases.length) {
            phrases = phrases.concat(newPhrases.map(function(phrase) {
                return {
                    phrase: phrase,
                    id: 0
                };
            }));
        }

        return phrases;
    },

    /**
     * Возвращает true, если кроме переданной фразы других активных нет
     * @param {BEM.MODEL} phraseModel
     * @returns {Boolean}
     */
    isLastActive: function(phraseModel) {
        var state = phraseModel.get('state');

        if (this.get('new_phrases').length > 0) return false;

        if (phraseModel.get('is_suspended') ||
            state != 'active' && state != 'new' && state != 'context') return false;

        var count = 0,
            modelId = phraseModel.get('modelId'),
            relevanceMatchModel = this.getRelevanceMatchModel(),
            relevanceMatchOn = relevanceMatchModel.get('bid_id') != '0' || this.get('has_relevance_match');

        this.getPhrasesModels().map(function(model) {
            state = model.get('state');

            if (model.get('modelId') !== modelId && state !== 'low_ctr' &&
                state !== 'declined' && !model.get('is_suspended') && !model.get('is_deleted')) {
                count++
            }
        }, this);

        modelId !== relevanceMatchModel.get('modelId') && relevanceMatchOn &&
            !relevanceMatchModel.get('is_suspended') && !relevanceMatchModel.get('is_deleted') &&
            count++;

        return count < 1;
    },

    /**
     * Возвращает количество ключевых фраз, которое еще можно добавить
     * @returns {Number}
     */
    getPhrasesLeft: function() {
        return this.getKeywordLimit() - this.getAllPhrases().length;
    },

    /**
     * Возвращает данные корректировок ставок
     * @returns {BEM.MODEL}
     */
    getMultipliersData: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: this.get('modelId') }).provideData();
    },

    /**
     * Возвращает модель региона для данной группы
     * @returns {BEM.MODEL}
     */
    getGeoModel: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-geo-regions', id: this.get('modelId'), parentModel: this });
    },

    /**
     * Возвращает данные в формате, пригодном для сохранения на сервере
     * @returns {Object}
     */
    provideData: function() {
        var data = this.toJSON(),
            geoModel = this.getGeoModel(),
            randPhrase = this.getRandomActivePhraseModel(),
            result = {};

        if (data.adgroup_id) {
            result.adgroup_id = data.adgroup_id;
        }

        result.adgroup_content_type = data.content_promotion_content_type;
        result.content_promotion_content_type = data.content_promotion_content_type;

        result.banners = this.getBanners()
            .filter(function(bannerModel) { return bannerModel.get('archive') !== 'Yes'; })
            .map(function(bannerModel) { return bannerModel.provideData(); });

        result.cid = this.get('cid');

        if (data.general_limit_price) {
            result.general_limit_price = data.general_limit_price;
        }

        result.geo = geoModel.get('geo');

        result.group_name = data.group_name;

        result.minus_words = data.minus_words;

        data.tags = {};

        this.get('tags').forEach(function(model) {
            data.tags[model.get('id')] = 1;
        });

        return result;
    },

    /**
     * Возвращает массив фраз, содержащихся в данной группе
     * @returns {Array}
     */
    getPhrases: function() {
        return this.getPhrasesModels().map(function(model) {
            return model.get('phrase');
        }, this);
    },

    /**
     * Возвращает массив с моделями фраз, содержащихся в данной группе
     * @returns {Array}
     */
    getPhrasesModels: function() {
        return this.get('phrasesIds').map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: this.get('isBidable') ? 'm-phrase-bidable' : 'm-phrase-text',
                id: id,
                parentModel: this
            });
        }, this);
    },

    /**
     * Возвращает true если хотя бы одна фраза из содержащихся в группе была изменена
     * @returns {Boolean}
     */
    isPhrasesChanged: function() {
        return this.getPhrasesModels().some(function(model) {
            return model.isChanged('phrase');
        }, this);
    },

    /**
     * Преобразовывает серверные данные по баннеру в модельные
     * @param {Object} data
     * @returns {Object}
     */
    bannerDataToModelData: function(data) {
        return u['dm-content-promotion-group'].transformBannerData({
            banner: data,
            group: this.provideData()
        });
    },

    /**
     * Преобразовывает серверные данные по группе в модельные (включая баннеры)
     * @param {Object} data
     * @returns {Object}
     */
    dataToModelData: function(data) {
        return u['dm-content-promotion-group'].transformData({
            group: data
        });
    },

    /**
     * Возвращает лимит ключевых слов на группу, установленный для пользователя
     * @returns {*}
     */
    getKeywordLimit: function() {
        return this.getCampaignModel().get('maxKeywordLimit');
    },

    /**
     * Возвращает инстанс родительской модели кампании.
     *
     * @returns {BEM.MODEL}
     */
    getCampaignModel: function() {
        return this._campaignModel || (this._campaignModel = this.get('cid') ?
            BEM.MODEL.getOrCreate({ name: 'm-campaign', id: this.get('cid') }) :
            BEM.MODEL.getOne('m-campaign'));
    },

    getRetargetingsData: function() {
        return [];
    },

    getRetargetingsModels: function() {
        return [];
    },

    /**
     * Возвращает модель бесфразного таргетинга (1 на группу)
     * @returns {*}
     */
    getRelevanceMatchModel: function() {
        return BEM.MODEL.getOrCreate({ name: 'm-relevance-match', id: this.get('modelId'), parentModel: this });
    },

    /**
     * Возвращает массив (серверное требование) с данными по бесфразному таргетингу
     * @returns {Array}
     */
    getRelevanceMatchData: function() {
        var model = this.getRelevanceMatchModel(),
            json = model.toJSON(),
            data = u._.pick(json, ['bid_id', 'is_suspended', 'search_stop', 'net_stop']);

        data.price = model.get('price', 'formatted');
        data.price_context = model.get('price_context', 'formatted');

        return [data];
    }

});
