u.register({

    'dm-content-promotion-group': {

        /**
         * Преобразовывает серверные данные группы в модельные
         * @param {Object} options
         * @param {Object} options.group
         * @param {Array} options.campaignTags
         * @returns {*}
         */
        transformData: function(options) {
            var group = options.group,
                campaignTags = options.campaignTags,
                data = [
                    'modelId',
                    'isBidable',
                    'adgroup_id',
                    'banners_quantity',
                    'group_banners_types',
                    'banners_arch_quantity',
                    'edit_banners_quantity',
                    'has_general_limit_price',
                    'hasCopyFromPrev',
                    'cid',
                    'camp_type',
                    'is_camp_archived',
                    'new_phrases',
                    'bannersCount',
                    'minus_words',
                    'shownBids',
                    'group_name',
                    'isBannersEditable',
                    'showNewBanners',
                    'newGroupIndex',
                    'isNewGroup',
                    'isCopyGroup',
                    'isSingleGroup',
                    'adgroup_type',
                    'statusMetricaStop',
                    'statusModerate',
                    'relevance_match',
                    'content_promotion_content_type'
                ].reduce(function(data, name) {
                    data[name] = group[name];

                    return data;
                }, {});

            if (!data.group_name) data.group_name = iget2('dm-content-promotion-group', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

            if (!data.content_promotion_content_type) data.content_promotion_content_type = u['content-promotion'].getDefaultContentType();

            //по пришедшим id тегов строим полный массив данных
            if (group.tags && !u._.isArray(group.tags)) {
                data.tags = Object.keys(group.tags).map(function(id) {
                    var cTag = (campaignTags || [])
                        .filter(function(tag) {
                            return tag.id == id;
                        })
                        .pop();

                    return {
                        id: id,
                        value: cTag && cTag.value
                    };
                });
            }

            data.banners = u._.isArray(group.banners) ?
                group.banners.map(function(banner) {
                    return u['dm-content-promotion-group'].transformBannerData({
                        banner: banner,
                        group: group
                    });
                }) :
                [
                    u['dm-content-promotion-group'].transformBannerData({
                        banner: group,
                        group: group
                    })
                ];

            data.phrasesIds = group.phrases ?
                group.phrases.map(function(phrase) {
                    return phrase.modelId;
                }, this) :
                [];

            data.has_relevance_match = group.has_relevance_match ||
                group.relevance_match && group.relevance_match.length > 0;

            data.adgroup_type = 'content_promotion';

            return data;
        },

        /**
         * Преобразовывает серверные данные баннера в модельные
         * @param {Object} options
         * @param {Object} options.banner
         * @param {Object} options.group
         * @returns {*}
         */
        transformBannerData: function(options) {
            // DIRECT-39276, DIRECT-49050: statusModerate - поле группы, но оно нужно для блока b-banner-status,
            // подобная логике есть в предобработке данных для баннеров/групп i-banners-group-data.bemtree.xjst
            options.banner.groupStatusModerate = options.group.statusModerate;

            options.banner.href = options.banner.content_promotion_visit_url ? u.stripHttp(options.banner.content_promotion_visit_url) : '';
            options.banner.url_protocol = u.getUrlProtocol(options.banner.content_promotion_visit_url);
            options.banner.description = options.banner.body;

            options.banner.ad_type = 'content_promotion';
            options.banner.content_promotion_content_type = options.group.content_promotion_content_type || u['content-promotion'].getDefaultContentType();

            return u.bannerModelData({
                banner: u.bannerData({
                    banner: options.banner
                }),
                group: options.group,
                loadVCardFromClient: false
            });
        }

    }

});
