BEM.MODEL.decl({ model: 'dm-cpm-banner-campaign', baseModel: 'dm-base-campaign' }, {

    // Таргетинг на устройства (данные о выбранных устройствах)
    device_targeting: 'string',

    // Дополнительные счетчики Метрики
    metrika_counters: 'string',

    // Включена ли разметка ссылок для метрики
    status_click_track: 'boolean',

    // 2й шаг, создание новой кампании
    isCreatingNewCamp: 'boolean',

    // Останавливать объявления при неработающем сайте
    statusMetricaControl: 'flag',

    // Внешняя интернет-статистика (метка «_openstat» на ссылках)
    statusOpenStat: 'flag',

    // Максимальное количество ключевых фраз на группу
    maxKeywordLimit: 'number',

    // Флаг говорит о том, что опция "Расширенный географический таргетинг" отключена
    no_extended_geotargeting: {
        type: 'enum',
        enum: [0, 1]
    },

    // количество показов в ограничении частоты показов
    rf: 'number',

    // количество дней в ограничении частоты показов ( = 0 если за весь период размещения)
    rfReset: 'number',

    // ключевые цели метрики (DIRECT-73912)
    meaningful_goals: 'array',

    // значения корректировок по каждому типу
    multipliersPct: 'object',

    // счетчики используемые в экспериментах
    counters_in_experiments: 'object',

    // получение выбранного охвата страте`xzгии
    strategy_cpm_auto_coverage: 'string',

    // pageId (идентификаторы страниц сайтов), на которых указывается рекламная кампания
    allowed_page_ids: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: u.consts('allowPageIdsLimit'),
                    text: u.pluralForms(
                        iget2(
                            'dm-cpm-banner-campaign',
                            'error-message-max-length',
                            'Превышена максимальная длина строки, {maxLength} {символ|символа|символов}.',
                            { maxLength: u.consts('allowPageIdsLimit') }
                        ),
                        u.consts('allowPageIdsLimit')
                    ),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    // запрещенные площадки для показа видео объявлений
    disabled_video_placements: 'array',

    // id brandlift-опроса
    brand_survey_id: 'string',

    // статус brandlift-опроса (в perl-вых данных этого поля нет, заполняется при получении статуса через java-ручку)
    brand_survey_state: {
        type: 'string',
        internal: true
    },

    // Стандарт определения видимости
    impression_standard_time: {
        type: 'enum',
        enum: ['yandex', 'mrc']
    },

    eshows_banner_rate: 'string',

    eshows_video_rate: 'string',

    eshows_video_type: {
        type: 'enum',
        enum: ['long_clicks', 'completes']
    }

}, {
    /**
     * Возвращает данные корректировок ставок
     * @returns {HierarchicalMultipliers}
     */
    getMultipliersData: function() {
        var id = this.get('cid') || 'new_camp';

        return BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: id }).provideData();
    }
});
